/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import org.dimdev.dimdoors.api.util.math.TransformationMatrix3d;

public final class MathUtil {
    public static <T> T weightedRandom(Map<T, Float> weights) {
        if (weights.size() == 0) {
            return null;
        }
        int totalWeight = 0;
        for (float weight : weights.values()) {
            totalWeight = (int)((float)totalWeight + weight);
        }
        class_5819 random = class_5819.method_43047();
        float f = random.method_43057() * (float)totalWeight;
        for (Map.Entry<T, Float> e : weights.entrySet()) {
            if (!((f -= e.getValue().floatValue()) < 0.0f)) continue;
            return e.getKey();
        }
        return null;
    }

    public static class_2379 eulerAngle(class_243 direction, class_243 upwards) {
        float pitch = MathUtil.pitch(direction);
        float yaw = MathUtil.yaw(direction);
        upwards = ((TransformationMatrix3d)TransformationMatrix3d.builder().rotate(new class_2379(pitch, yaw, 0.0f)).buildReverse()).transform(upwards);
        float roll = (float)Math.toDegrees(-Math.atan2(upwards.field_1352, upwards.field_1351));
        return new class_2379(pitch, yaw, roll);
    }

    public static class_2379 entityEulerAngle(class_1297 entity) {
        return new class_2379(entity.method_36455(), entity.method_36454(), 0.0f);
    }

    public static float yaw(class_243 vector) {
        return (float)Math.toDegrees(-Math.atan2(vector.field_1352, vector.field_1350));
    }

    public static float pitch(class_243 vector) {
        return (float)Math.toDegrees(Math.asin(-vector.field_1351));
    }

    public static class_2379 directionEulerAngle(class_2350 direction) {
        switch (direction) {
            case field_11033: {
                return EulerAngleDirection.DOWN.getAngle();
            }
            case field_11036: {
                return EulerAngleDirection.UP.getAngle();
            }
            case field_11043: {
                return EulerAngleDirection.NORTH.getAngle();
            }
            case field_11035: {
                return EulerAngleDirection.SOUTH.getAngle();
            }
            case field_11039: {
                return EulerAngleDirection.WEST.getAngle();
            }
        }
        return EulerAngleDirection.EAST.getAngle();
    }

    public static enum EulerAngleDirection {
        DOWN(new class_2379(90.0f, 0.0f, 0.0f)),
        UP(new class_2379(-90.0f, 0.0f, 0.0f)),
        NORTH(new class_2379(0.0f, -180.0f, 0.0f)),
        SOUTH(new class_2379(0.0f, 0.0f, 0.0f)),
        WEST(new class_2379(0.0f, 90.0f, 0.0f)),
        EAST(new class_2379(0.0f, -90.0f, 0.0f));

        private final class_2379 angle;

        private EulerAngleDirection(class_2379 angle) {
            this.angle = angle;
        }

        public class_2379 getAngle() {
            return this.angle;
        }
    }
}

