/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_3532;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface Equation {
    public static final double FALSE = 0.0;
    public static final double TRUE = 1.0;

    public double apply(Map<String, Double> var1);

    default public String asString() {
        return this.visit(new StringBuilder()).toString();
    }

    public StringBuilder visit(StringBuilder var1);

    default public boolean asBoolean(Map<String, Double> variableMap) {
        return Equation.toBoolean(this.apply(variableMap));
    }

    public static Equation parse(String equationString) throws EquationParseException {
        return StringEquationParser.INSTANCE.parse(equationString);
    }

    public static double toDouble(boolean value) {
        return value ? 1.0 : 0.0;
    }

    public static boolean toBoolean(double value) {
        return value != 0.0;
    }

    public static Equation newEquation(final Function<Map<String, Double>, Double> apply, final UnaryOperator<StringBuilder> visit) {
        return new Equation(){

            @Override
            public double apply(Map<String, Double> variableMap) {
                return (Double)apply.apply(variableMap);
            }

            @Override
            public StringBuilder visit(StringBuilder builder) {
                return (StringBuilder)visit.apply(builder);
            }
        };
    }

    public static class StringEquationParser {
        private static final Logger LOGGER = LogManager.getLogger();
        public static StringEquationParser INSTANCE = new StringEquationParser();
        private static final List<EquationParser> parseRules = new ArrayList<EquationParser>();

        public Equation parse(String equationString) throws EquationParseException {
            equationString = equationString.replaceAll("\\s", "");
            for (EquationParser parser : parseRules) {
                Optional<Equation> equation = parser.tryParse(equationString);
                if (!equation.isPresent()) continue;
                return equation.get();
            }
            throw new EquationParseException("\"" + equationString + "\" could not be parsed");
        }

        static {
            parseRules.add(toParse -> {
                if (!toParse.startsWith("(") || !toParse.endsWith(")")) {
                    return Optional.empty();
                }
                Equation equation = Equation.parse(toParse.substring(1, toParse.length() - 1));
                return Optional.of(Equation.newEquation(equation::apply, stringBuilder -> equation.visit(stringBuilder.append("(")).append(")")));
            });
            parseRules.add(toParse -> {
                try {
                    Double result = Double.parseDouble(toParse);
                    return Optional.of(Equation.newEquation(stringDoubleMap -> result, builder -> builder.append(toParse)));
                }
                catch (NumberFormatException e) {
                    return Optional.empty();
                }
            });
            parseRules.add(new SplitterParser().add((variableMap, equations) -> equations[0].asBoolean((Map<String, Double>)variableMap) ? equations[1].apply((Map<String, Double>)variableMap) : equations[2].apply((Map<String, Double>)variableMap), "?", ":"));
            parseRules.add(new SplitterParser().add((variableMap, equations) -> Equation.toDouble(equations[0].asBoolean((Map<String, Double>)variableMap) || equations[1].asBoolean((Map<String, Double>)variableMap)), "||"));
            parseRules.add(new SplitterParser().add((variableMap, equations) -> Equation.toDouble(equations[0].asBoolean((Map<String, Double>)variableMap) && equations[1].asBoolean((Map<String, Double>)variableMap)), "&&"));
            parseRules.add(new SplitterParser().add((variableMap, equations) -> Equation.toDouble(equations[0].apply((Map<String, Double>)variableMap) == equations[1].apply((Map<String, Double>)variableMap)), "==").add((variableMap, equations) -> Equation.toDouble(equations[0].apply((Map<String, Double>)variableMap) <= equations[1].apply((Map<String, Double>)variableMap)), "<=").add((variableMap, equations) -> Equation.toDouble(equations[0].apply((Map<String, Double>)variableMap) >= equations[1].apply((Map<String, Double>)variableMap)), ">=").add((variableMap, equations) -> Equation.toDouble(equations[0].apply((Map<String, Double>)variableMap) < equations[1].apply((Map<String, Double>)variableMap)), "<").add((variableMap, equations) -> Equation.toDouble(equations[0].apply((Map<String, Double>)variableMap) > equations[1].apply((Map<String, Double>)variableMap)), ">"));
            parseRules.add(new SplitterParser().add((variableMap, equations) -> equations[0].apply((Map<String, Double>)variableMap) + equations[1].apply((Map<String, Double>)variableMap), "+").add((variableMap, equations) -> equations[0].apply((Map<String, Double>)variableMap) - equations[1].apply((Map<String, Double>)variableMap), "-"));
            parseRules.add(new SplitterParser().add((variableMap, equations) -> equations[0].apply((Map<String, Double>)variableMap) * equations[1].apply((Map<String, Double>)variableMap), "*").add((variableMap, equations) -> equations[0].apply((Map<String, Double>)variableMap) / equations[1].apply((Map<String, Double>)variableMap), "/").add((variableMap, equations) -> equations[0].apply((Map<String, Double>)variableMap) % equations[1].apply((Map<String, Double>)variableMap), "%"));
            parseRules.add(new SplitterParser().add((variableMap, equations) -> Math.pow(equations[0].apply((Map<String, Double>)variableMap), equations[1].apply((Map<String, Double>)variableMap)), "^"));
            parseRules.add(new FunctionParser("H", 1, 1, (stringDoubleMap, equations) -> equations[0].apply((Map<String, Double>)stringDoubleMap) >= 0.0 ? 1.0 : 0.0));
            parseRules.add(new FunctionParser("floor", 1, 1, (stringDoubleMap, equations) -> Math.floor(equations[0].apply((Map<String, Double>)stringDoubleMap))));
            parseRules.add(new FunctionParser("ceil", 1, 1, (stringDoubleMap, equations) -> Math.ceil(equations[0].apply((Map<String, Double>)stringDoubleMap))));
            parseRules.add(new FunctionParser("max", 2, -1, (stringDoubleMap, equations) -> {
                Double max = equations[0].apply((Map<String, Double>)stringDoubleMap);
                for (int i = 1; i < ((Equation[])equations).length; ++i) {
                    max = Math.max(max, equations[i].apply((Map<String, Double>)stringDoubleMap));
                }
                return max;
            }));
            parseRules.add(new FunctionParser("min", 2, -1, (stringDoubleMap, equations) -> {
                Double min = equations[0].apply((Map<String, Double>)stringDoubleMap);
                for (int i = 1; i < ((Equation[])equations).length; ++i) {
                    min = Math.min(min, equations[i].apply((Map<String, Double>)stringDoubleMap));
                }
                return min;
            }));
            parseRules.add(new FunctionParser("clamp", 3, 3, (stringDoubleMap, equations) -> class_3532.method_15350((double)equations[0].apply((Map<String, Double>)stringDoubleMap), (double)equations[1].apply((Map<String, Double>)stringDoubleMap), (double)equations[2].apply((Map<String, Double>)stringDoubleMap))));
            parseRules.add(new FunctionParser("random", 0, 0, (stringDoubleMap, equations) -> Math.random()));
            parseRules.add(new VariableReplacer());
        }

        @FunctionalInterface
        private static interface EquationParser {
            public Optional<Equation> tryParse(String var1) throws EquationParseException;
        }

        private static class SplitterParser
        implements EquationParser {
            private final Map<String, Pair<String[], BiFunction<Map<String, Double>, Equation[], Double>>> operations = new HashMap<String, Pair<String[], BiFunction<Map<String, Double>, Equation[], Double>>>();

            public SplitterParser add(BiFunction<Map<String, Double>, Equation[], Double> function, String ... symbols) {
                List<String> symbolList = Arrays.asList(symbols);
                Collections.reverse(symbolList);
                this.operations.put(symbolList.get(0), (Pair<String[], BiFunction<Map<String, Double>, Equation[], Double>>)new Pair((Object)symbolList.toArray(new String[0]), function));
                return this;
            }

            @Override
            public Optional<Equation> tryParse(String toParse) throws EquationParseException {
                int depth = 0;
                for (int i = toParse.length() - 1; i >= 1; --i) {
                    String substring = toParse.substring(i);
                    if (substring.startsWith(")")) {
                        ++depth;
                    } else if (substring.startsWith("(")) {
                        --depth;
                    }
                    for (String currentSymbol : this.operations.keySet()) {
                        if (depth != 0 || !substring.startsWith(currentSymbol)) continue;
                        Pair<String[], BiFunction<Map<String, Double>, Equation[], Double>> operation = this.operations.get(currentSymbol);
                        String[] symbols = (String[])operation.getFirst();
                        ArrayList<Pair> partIndices = new ArrayList<Pair>(symbols.length + 1);
                        partIndices.add(new Pair((Object)(i + currentSymbol.length()), (Object)toParse.length()));
                        int symbolPointer = 1;
                        if (symbolPointer < symbols.length) {
                            currentSymbol = symbols[symbolPointer];
                        }
                        int endIndex = i;
                        int innerDepth = 0;
                        for (int j = i - 1; j >= 1 && symbolPointer < symbols.length; --j) {
                            String innerSubstring = toParse.substring(j);
                            if (innerSubstring.startsWith(")")) {
                                ++innerDepth;
                            } else if (innerSubstring.startsWith("(")) {
                                --innerDepth;
                            }
                            if (innerDepth != 0 || !innerSubstring.startsWith(currentSymbol)) continue;
                            partIndices.add(new Pair((Object)(j + currentSymbol.length()), (Object)endIndex));
                            endIndex = j;
                            if (++symbolPointer >= symbols.length) continue;
                            currentSymbol = symbols[symbolPointer];
                        }
                        if (symbolPointer < symbols.length) continue;
                        partIndices.add(new Pair((Object)0, (Object)endIndex));
                        Equation[] equations = new Equation[partIndices.size()];
                        for (int j = 0; j < partIndices.size(); ++j) {
                            Pair pair = (Pair)partIndices.get(j);
                            equations[partIndices.size() - j - 1] = Equation.parse(toParse.substring((Integer)pair.getFirst(), (Integer)pair.getSecond()));
                        }
                        return Optional.of(Equation.newEquation(stringDoubleMap -> (Double)((BiFunction)operation.getSecond()).apply(stringDoubleMap, equations), stringBuilder -> {
                            for (int j = 0; j < symbols.length; ++j) {
                                equations[j].visit((StringBuilder)stringBuilder).append(symbols[symbols.length - 1 - j]);
                            }
                            equations[equations.length - 1].visit((StringBuilder)stringBuilder);
                            return stringBuilder;
                        }));
                    }
                }
                return Optional.empty();
            }
        }

        private static class FunctionParser
        implements EquationParser {
            private final String functionString;
            private final int minArguments;
            private final int maxArguments;
            private final BiFunction<Map<String, Double>, Equation[], Double> function;

            public FunctionParser(String functionString, int minArguments, int maxArguments, BiFunction<Map<String, Double>, Equation[], Double> function) {
                this.functionString = functionString + "(";
                this.minArguments = minArguments;
                this.maxArguments = maxArguments;
                this.function = function;
            }

            @Override
            public Optional<Equation> tryParse(String toParse) throws EquationParseException {
                if (!toParse.startsWith(this.functionString) || !toParse.endsWith(")")) {
                    return Optional.empty();
                }
                String[] arguments = toParse.substring(this.functionString.length(), toParse.length() - 1).split(",", -1);
                if (arguments.length == 1 && arguments[0].equals("") && this.minArguments == 0) {
                    return Optional.of(Equation.newEquation(stringDoubleMap -> this.function.apply((Map<String, Double>)stringDoubleMap, new Equation[0]), stringBuilder -> stringBuilder.append(this.functionString).append(")")));
                }
                if (this.minArguments > arguments.length || this.maxArguments < arguments.length && this.maxArguments != -1) {
                    return Optional.empty();
                }
                Equation[] argumentEquations = new Equation[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    argumentEquations[i] = Equation.parse(arguments[i]);
                }
                return Optional.of(Equation.newEquation(stringDoubleMap -> this.function.apply((Map<String, Double>)stringDoubleMap, argumentEquations), stringBuilder -> {
                    stringBuilder.append(this.functionString);
                    argumentEquations[0].visit((StringBuilder)stringBuilder);
                    for (int i = 1; i < argumentEquations.length; ++i) {
                        stringBuilder.append(",");
                        argumentEquations[i].visit((StringBuilder)stringBuilder);
                    }
                    return stringBuilder.append(")");
                }));
            }
        }

        private static class VariableReplacer
        implements EquationParser {
            private VariableReplacer() {
            }

            @Override
            public Optional<Equation> tryParse(String toParse) {
                if (!toParse.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
                    return Optional.empty();
                }
                return Optional.of(Equation.newEquation(stringDoubleMap -> {
                    if (stringDoubleMap != null && stringDoubleMap.containsKey(toParse)) {
                        return (Double)stringDoubleMap.get(toParse);
                    }
                    LOGGER.error("Variable \"" + toParse + "\" was not passed to equation! Returning 0 as fallback.");
                    return 0.0;
                }, stringBuilder -> stringBuilder.append(toParse)));
            }
        }

        @FunctionalInterface
        private static interface TriFunction<T, U, V, R> {
            public R apply(T var1, U var2, V var3);
        }
    }

    public static class EquationParseException
    extends Exception {
        public EquationParseException(String message) {
            super(message);
        }
    }
}

