/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import org.dimdev.dimdoors.api.util.math.Matrixd;
import org.dimdev.dimdoors.api.util.math.Vectord;

public abstract class AbstractMatrixd<T extends AbstractMatrixd<T>> {
    private final int dimensionX;
    private final int dimensionY;
    protected double[][] matrix;

    public AbstractMatrixd(double[][] matrix) {
        if (matrix.length > 0) {
            int length = matrix[0].length;
            for (int i = 1; i < matrix.length; ++i) {
                if (length == matrix[i].length) continue;
                throw new UnsupportedOperationException("Cannot create Matrix from 2D array consisting of non equal length arrays.");
            }
        }
        this.matrix = matrix;
        this.dimensionX = matrix.length;
        this.dimensionY = matrix[0].length;
    }

    public AbstractMatrixd(AbstractMatrixd<?> matrixd) {
        this.matrix = matrixd.getMatrix();
        this.dimensionX = matrixd.getDimensionX();
        this.dimensionY = matrixd.getDimensionY();
    }

    public AbstractMatrixd(Vectord ... vectors) {
        double[][] matrix = new double[vectors.length][vectors[0].size()];
        for (int i = 0; i < vectors.length; ++i) {
            matrix[i] = vectors[i].getVec();
        }
        int length = matrix[0].length;
        for (int i = 1; i < matrix.length; ++i) {
            if (length == matrix[i].length) continue;
            throw new UnsupportedOperationException("Cannot create Matrix from 2D array consisting of non equal length arrays.");
        }
        this.matrix = matrix;
        this.dimensionX = matrix.length;
        this.dimensionY = matrix[0].length;
    }

    public abstract T construct(double[][] var1);

    public abstract T construct(AbstractMatrixd<?> var1);

    public abstract T construct(Vectord ... var1);

    public int getDimensionX() {
        return this.dimensionX;
    }

    public int getDimensionY() {
        return this.dimensionY;
    }

    private double[][] getMatrix() {
        return this.matrix;
    }

    public double get(int column, int row) {
        return this.matrix[column][row];
    }

    public Vectord getColumn(int column) {
        return new Vectord(this.matrix[column]);
    }

    public Vectord getRow(int row) {
        double[] rowArray = new double[this.dimensionX];
        for (int i = 0; i < this.dimensionX; ++i) {
            rowArray[i] = this.matrix[i][row];
        }
        return new Vectord(rowArray);
    }

    public T set(int column, int row, double value) {
        T updated = this.construct(this);
        ((AbstractMatrixd)updated).matrix[column][row] = value;
        return updated;
    }

    public T setColumn(int column, Vectord vector) {
        if (vector.size() != this.dimensionY) {
            throw new UnsupportedOperationException("Cannot replace column with one of non matching length");
        }
        T updated = this.construct(this);
        ((AbstractMatrixd)updated).matrix[column] = vector.getVec();
        return updated;
    }

    public T setRow(int row, Vectord vector) {
        if (vector.size() != this.dimensionX) {
            throw new UnsupportedOperationException("Cannot replace row with one of non matching length");
        }
        T updated = this.construct(this);
        for (int i = 0; i < vector.size(); ++i) {
            ((AbstractMatrixd)updated).matrix[i][row] = vector.get(i);
        }
        return updated;
    }

    public T dropColumn(int column) {
        double[][] matrix = new double[this.dimensionX - 1][this.dimensionY];
        for (int i = 0; i < this.dimensionX; ++i) {
            if (i == column) continue;
            matrix[i < column ? i : i - 1] = this.matrix[i];
        }
        return this.construct(matrix);
    }

    public T dropRow(int row) {
        double[][] matrix = new double[this.dimensionX - 1][this.dimensionY];
        for (int i = 0; i < this.dimensionX; ++i) {
            for (int j = 0; j < this.dimensionY; ++j) {
                if (j == row) continue;
                matrix[i][j < row ? j : j - 1] = this.matrix[i][j];
            }
        }
        return this.construct(matrix);
    }

    public T dropColumnAndRow(int column, int row) {
        double[][] matrix = new double[this.dimensionX - 1][this.dimensionY];
        for (int i = 0; i < this.dimensionX; ++i) {
            if (i == column) continue;
            for (int j = 0; j < this.dimensionY; ++j) {
                if (j == row) continue;
                matrix[i < column ? i : i - 1][j < row ? j : j - 1] = this.matrix[i][j];
            }
        }
        return this.construct(matrix);
    }

    public Vectord asVector() {
        if (this.dimensionX != 1 && this.dimensionY != 1) {
            throw new UnsupportedOperationException("Cannot get Matrix of non vector dimensions as vector.");
        }
        if (this.dimensionX == 1) {
            return this.getColumn(0);
        }
        return this.getRow(0);
    }

    public T transpose() {
        double[][] transposed = new double[this.dimensionY][this.dimensionX];
        for (int i = 0; i < this.dimensionX; ++i) {
            for (int j = 0; j < this.dimensionY; ++j) {
                transposed[j][i] = this.matrix[j][i];
            }
        }
        return this.construct(transposed);
    }

    public double determinant() {
        if (this.dimensionY != this.dimensionX) {
            throw new UnsupportedOperationException("Cannot get the determinant of matrix with differing dimensions.");
        }
        return this.det();
    }

    protected double det() {
        if (this.dimensionX == 0) {
            return 1.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.dimensionX; ++i) {
            if (i % 2 == 0) {
                sum += this.matrix[i][0] * ((AbstractMatrixd)this.dropColumnAndRow(i, 0)).det();
                continue;
            }
            sum -= this.matrix[i][0] * ((AbstractMatrixd)this.dropColumnAndRow(i, 0)).det();
        }
        return sum;
    }

    public T product(AbstractMatrixd<?> matrix) {
        if (this.dimensionX != matrix.dimensionY) {
            throw new UnsupportedOperationException("Cannot perform matrix product on matrices of non matching row length and column length");
        }
        double[][] result = new double[matrix.dimensionX][this.dimensionY];
        for (int i = 0; i < matrix.dimensionX; ++i) {
            for (int j = 0; j < this.dimensionY; ++j) {
                result[i][j] = matrix.getColumn(i).dot(this.getRow(j));
            }
        }
        return this.construct(result);
    }

    public Matrixd universalProduct(AbstractMatrixd<?> matrix) {
        if (this.dimensionX != matrix.dimensionY) {
            throw new UnsupportedOperationException("Cannot perform matrix product on matrices of non matching row length and column length");
        }
        double[][] result = new double[matrix.dimensionX][this.dimensionY];
        for (int i = 0; i < matrix.dimensionX; ++i) {
            for (int j = 0; j < this.dimensionY; ++j) {
                result[i][j] = matrix.getColumn(i).dot(this.getRow(j));
            }
        }
        return new Matrixd(result);
    }

    public Vectord product(Vectord vector) {
        Matrixd matrix = new Matrixd(vector);
        return this.universalProduct(matrix).asVector();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int j = 0; j < this.matrix[0].length; ++j) {
            stringBuilder.append("[");
            for (int i = 0; i < this.matrix.length; ++i) {
                stringBuilder.append(this.matrix[i][j]);
                if (i >= this.matrix.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            if (j >= this.matrix[0].length - 1) continue;
            stringBuilder.append(",\n");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractMatrixd)) {
            return false;
        }
        AbstractMatrixd matrixd = (AbstractMatrixd)o;
        if (matrixd.dimensionX != this.dimensionX || matrixd.dimensionY != this.dimensionY) {
            return false;
        }
        for (int i = 0; i < this.dimensionX; ++i) {
            for (int j = 0; j < this.dimensionY; ++j) {
                if (matrixd.matrix[i][j] == this.matrix[i][j]) continue;
                return false;
            }
        }
        return true;
    }
}

