/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import net.minecraft.class_2960;

public class Path<K> {
    private final ArrayList<K> path;

    @SafeVarargs
    public Path(K ... path) {
        this.path = new ArrayList<K>(Arrays.asList(path));
    }

    public Path(List<K> path) {
        this.path = new ArrayList<K>(path);
    }

    @SafeVarargs
    public final Path<K> subPath(K ... subPath) {
        ArrayList<K> arrayList = new ArrayList<K>(this.path);
        arrayList.addAll(Arrays.asList(subPath));
        return new Path<K>(arrayList);
    }

    public Path<K> subPath(Path<K> subPath) {
        ArrayList<K> arrayList = new ArrayList<K>(this.path);
        arrayList.addAll(subPath.path);
        return new Path<K>(arrayList);
    }

    public Queue<K> asQueue() {
        return new LinkedList<K>(this.path);
    }

    public Optional<K> reduce(BinaryOperator<K> accumulator) {
        return this.path.stream().reduce(accumulator);
    }

    public K reduce(K identity, BinaryOperator<K> accumulator) {
        return (K)this.path.stream().reduce(identity, accumulator);
    }

    public <T> T reduce(T identity, BiFunction<T, ? super K, T> accumulator, BinaryOperator<T> combiner) {
        return this.path.stream().reduce(identity, accumulator, combiner);
    }

    public static Path<String> stringPath(String str) {
        return new Path<String>(str.split("(?<=[/:])"));
    }

    public static Path<String> stringPath(class_2960 id) {
        return Path.stringPath(id.toString());
    }

    public String toString() {
        return "Path{path=" + this.reduce("", (left, right) -> left + ";" + right.toString(), (left, right) -> left + ";" + right) + "}";
    }
}

