/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors;

import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.GameInstance;
import java.nio.file.Path;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.dimdev.dimdoors.ModConfig;
import org.dimdev.dimdoors.api.event.ChunkServedCallback;
import org.dimdev.dimdoors.api.event.UseItemOnBlockCallback;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlockRegistrar;
import org.dimdev.dimdoors.block.door.WaterLoggableDoorBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.command.ModCommands;
import org.dimdev.dimdoors.criteria.ModCriteria;
import org.dimdev.dimdoors.enchantment.ModEnchants;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.entity.stat.ModStats;
import org.dimdev.dimdoors.fabric.DimensionalDoorsImpl;
import org.dimdev.dimdoors.fluid.ModFluids;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.item.door.DimensionalDoorItemRegistrar;
import org.dimdev.dimdoors.item.door.DoorRiftDataLoader;
import org.dimdev.dimdoors.item.door.data.condition.Condition;
import org.dimdev.dimdoors.listener.AttackBlockCallbackListener;
import org.dimdev.dimdoors.listener.ChunkLoadListener;
import org.dimdev.dimdoors.listener.UseDoorItemOnBlockCallbackListener;
import org.dimdev.dimdoors.listener.pocket.PocketAttackBlockCallbackListener;
import org.dimdev.dimdoors.listener.pocket.UseBlockCallbackListener;
import org.dimdev.dimdoors.listener.pocket.UseItemCallbackListener;
import org.dimdev.dimdoors.listener.pocket.UseItemOnBlockCallbackListener;
import org.dimdev.dimdoors.network.ServerPacketHandler;
import org.dimdev.dimdoors.particle.ModParticleTypes;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.virtual.ImplementedVirtualPocket;
import org.dimdev.dimdoors.recipe.ModRecipeSerializers;
import org.dimdev.dimdoors.recipe.ModRecipeTypes;
import org.dimdev.dimdoors.rift.registry.RegistryVertex;
import org.dimdev.dimdoors.rift.targets.Targets;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.screen.ModScreenHandlerTypes;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.util.schematic.SchemFixer;
import org.dimdev.dimdoors.world.ModBiomes;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.ModStructures;
import org.dimdev.dimdoors.world.decay.Decay;
import org.dimdev.dimdoors.world.decay.DecayPredicate;
import org.dimdev.dimdoors.world.decay.DecayProcessorType;
import org.dimdev.dimdoors.world.feature.ModFeatures;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;
import org.jetbrains.annotations.Nullable;

public class DimensionalDoors {
    public static final String MOD_ID = "dimdoors";
    private static Mod dimDoorsMod;
    private static DimensionalDoorItemRegistrar dimensionalDoorItemRegistrar;
    private static DimensionalDoorBlockRegistrar dimensionalDoorBlockRegistrar;
    private static Supplier<Path> CONFIG_ROOT;
    private static final ConfigHolder<ModConfig> CONFIG_MANAGER;
    public static final NetworkChannel NETWORK;

    public static class_2960 id(String id) {
        return new class_2960(MOD_ID, id);
    }

    public static MinecraftServer getServer() {
        return GameInstance.getServer();
    }

    public static class_3218 getWorld(class_5321<class_1937> world) {
        return DimensionalDoors.getServer().method_3847(world);
    }

    public static ModConfig getConfig() {
        return (ModConfig)CONFIG_MANAGER.get();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigRoot() {
        return DimensionalDoorsImpl.getConfigRoot();
    }

    public static void init() {
        dimDoorsMod = Platform.getMod((String)MOD_ID);
        DimensionalDoors.registerRegistries();
        ModRecipeTypes.init();
        ModRecipeSerializers.init();
        ModScreenHandlerTypes.init();
        ModSoundEvents.init();
        ModFluids.init();
        ModEntityTypes.init();
        ModItems.init();
        ModBlocks.init();
        ModFeatures.init();
        ModBiomes.init();
        ModDimensions.init();
        ModStructures.init();
        ModStats.init();
        ModBlockEntityTypes.init();
        ModCommands.init();
        ModParticleTypes.init();
        ModCriteria.init();
        ModEnchants.init();
        dimensionalDoorItemRegistrar = new DimensionalDoorItemRegistrar();
        dimensionalDoorBlockRegistrar = new DimensionalDoorBlockRegistrar(dimensionalDoorItemRegistrar);
        ServerPacketHandler.init();
        DimensionalDoors.initBuiltinPacks();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)PocketLoader.getInstance());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)Decay.DecayLoader.getInstance());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)DoorRiftDataLoader.getInstance());
        DimensionalDoors.registerListeners();
        SchemFixer.run();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void initBuiltinPacks() {
        DimensionalDoorsImpl.initBuiltinPacks();
    }

    public static void registerRegistries() {
        Targets.registerDefaultTargets();
        VirtualTarget.VirtualTargetType.register();
        ImplementedVirtualPocket.VirtualPocketType.register();
        RegistryVertex.RegistryVertexType.register();
        Modifier.ModifierType.register();
        PocketGenerator.PocketGeneratorType.register();
        AbstractPocket.AbstractPocketType.register();
        PocketAddon.PocketAddonType.register();
        Condition.ConditionType.register();
        DecayPredicate.DecayPredicateType.register();
        DecayProcessorType.register();
    }

    private static void registerListeners() {
        ChunkServedCallback.EVENT.register((Object)new ChunkLoadListener());
        InteractionEvent.LEFT_CLICK_BLOCK.register((Object)new AttackBlockCallbackListener());
        InteractionEvent.LEFT_CLICK_BLOCK.register((Object)new PocketAttackBlockCallbackListener());
        InteractionEvent.RIGHT_CLICK_ITEM.register((Object)new UseItemCallbackListener());
        UseItemOnBlockCallback.EVENT.register((Object)new UseItemOnBlockCallbackListener());
        InteractionEvent.RIGHT_CLICK_BLOCK.register((Object)new UseBlockCallbackListener());
        UseItemOnBlockCallback.EVENT.register((Object)new UseDoorItemOnBlockCallbackListener());
        TickEvent.SERVER_LEVEL_PRE.register(Decay::tick);
    }

    public static DimensionalDoorItemRegistrar getDimensionalDoorItemRegistrar() {
        return dimensionalDoorItemRegistrar;
    }

    public static DimensionalDoorBlockRegistrar getDimensionalDoorBlockRegistrar() {
        return dimensionalDoorBlockRegistrar;
    }

    public static Mod getDimDoorsMod() {
        return dimDoorsMod;
    }

    public static void afterBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        if (player.method_7337() && !DimensionalDoors.getConfig().getDoorsConfig().placeRiftsInCreativeMode) {
            return;
        }
        if (blockEntity instanceof EntranceRiftBlockEntity) {
            EntranceRiftBlockEntity riftBlockEntity = (EntranceRiftBlockEntity)blockEntity;
            if (state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12607) {
                world.method_8501(pos, (class_2680)((class_2248)ModBlocks.DETACHED_RIFT.get()).method_9564().method_11657((class_2769)WaterLoggableDoorBlock.WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WaterLoggableDoorBlock.WATERLOGGED))));
                ((DetachedRiftBlockEntity)world.method_8321(pos)).setData(riftBlockEntity.getData());
            } else {
                world.method_8501(pos.method_10074(), (class_2680)((class_2248)ModBlocks.DETACHED_RIFT.get()).method_9564().method_11657((class_2769)WaterLoggableDoorBlock.WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WaterLoggableDoorBlock.WATERLOGGED))));
                ((DetachedRiftBlockEntity)world.method_8321(pos.method_10074())).setData(riftBlockEntity.getData());
            }
        }
    }

    static {
        CONFIG_ROOT = () -> (Path)dimDoorsMod.getFilePaths().get(0);
        CONFIG_MANAGER = AutoConfig.register(ModConfig.class, ModConfig.SubRootJanksonConfigSerializer::new);
        NETWORK = NetworkChannel.create((class_2960)DimensionalDoors.id("server"));
    }
}

