/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.network;

import java.util.function.Supplier;
import link.infra.demagnetize.blocks.DemagnetizerTileEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketDemagnetizerSettings {
    private static final Logger LOGGER = LogManager.getLogger();
    private int range;
    private DemagnetizerTileEntity.RedstoneStatus redstoneSetting = DemagnetizerTileEntity.RedstoneStatus.REDSTONE_DISABLED;
    private boolean whitelist;
    private BlockPos demagnetizerBlockPos;

    private PacketDemagnetizerSettings() {
    }

    public PacketDemagnetizerSettings(int range, DemagnetizerTileEntity.RedstoneStatus redstoneSetting, boolean whitelist, BlockPos demagnetizerBlockPos) {
        this.range = range;
        this.redstoneSetting = redstoneSetting;
        this.whitelist = whitelist;
        this.demagnetizerBlockPos = demagnetizerBlockPos;
    }

    void encode(PacketBuffer buf) {
        buf.writeInt(this.range);
        buf.writeChar(this.redstoneSetting.getNum());
        buf.writeBoolean(this.whitelist);
        buf.func_179255_a(this.demagnetizerBlockPos);
    }

    static PacketDemagnetizerSettings decode(PacketBuffer buf) {
        PacketDemagnetizerSettings p = new PacketDemagnetizerSettings();
        p.range = buf.readInt();
        p.redstoneSetting = DemagnetizerTileEntity.RedstoneStatus.parse(buf.readChar());
        if (p.redstoneSetting == null) {
            p.redstoneSetting = DemagnetizerTileEntity.RedstoneStatus.REDSTONE_DISABLED;
        }
        p.whitelist = buf.readBoolean();
        p.demagnetizerBlockPos = buf.func_179259_c();
        return p;
    }

    void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity playerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (playerEntity == null) {
                return;
            }
            World world = playerEntity.func_130014_f_();
            if (world.isAreaLoaded(this.demagnetizerBlockPos, 1)) {
                TileEntity te = world.func_175625_s(this.demagnetizerBlockPos);
                if (te instanceof DemagnetizerTileEntity) {
                    DemagnetizerTileEntity demagTE = (DemagnetizerTileEntity)te;
                    demagTE.setRange(this.range);
                    demagTE.setRedstoneSetting(this.redstoneSetting);
                    demagTE.setWhitelist(this.whitelist);
                    demagTE.updateBlock();
                } else {
                    LOGGER.warn("Player tried to change settings of something that isn't a demagnetizer (or doesn't have a TE)!");
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

