/*
 * Decompiled with CFR 0.152.
 */
package link.infra.demagnetize.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import link.infra.demagnetize.blocks.DemagnetizerContainer;
import link.infra.demagnetize.blocks.DemagnetizerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DemagnetizerGui
extends ContainerScreen<DemagnetizerContainer> {
    private static final ResourceLocation background = new ResourceLocation("demagnetize", "textures/gui/demagnetizer.png");
    private final DemagnetizerTileEntity te;
    private IconButton rsButton;
    private IconButton whitelistButton;
    private final boolean hasFilter;

    public DemagnetizerGui(DemagnetizerContainer inventorySlotsIn, PlayerInventory inv, ITextComponent name) {
        super((Container)inventorySlotsIn, inv, name);
        this.te = inventorySlotsIn.te;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.hasFilter = this.te.getFilterSize() > 0;
    }

    public void func_231160_c_() {
        int currentRSState;
        super.func_231160_c_();
        this.func_230480_a_((Widget)new RangeSlider(this.field_147003_i + 7, this.field_147009_r + 17, this.te.getMaxRange(), this.te.getRange()));
        String[] rsStates = new String[]{"rsignored", "rson", "rsoff"};
        switch (this.te.getRedstoneSetting()) {
            case POWERED: {
                currentRSState = 1;
                break;
            }
            case UNPOWERED: {
                currentRSState = 2;
                break;
            }
            default: {
                currentRSState = 0;
            }
        }
        this.rsButton = new IconButton(this.field_147003_i + 124, this.field_147009_r + 17, rsStates, currentRSState, background, 0, 184){

            @Override
            public void updateState(int currentState) {
                switch (currentState) {
                    case 0: {
                        DemagnetizerGui.this.te.setRedstoneSetting(DemagnetizerTileEntity.RedstoneStatus.REDSTONE_DISABLED);
                        break;
                    }
                    case 1: {
                        DemagnetizerGui.this.te.setRedstoneSetting(DemagnetizerTileEntity.RedstoneStatus.POWERED);
                        break;
                    }
                    case 2: {
                        DemagnetizerGui.this.te.setRedstoneSetting(DemagnetizerTileEntity.RedstoneStatus.UNPOWERED);
                    }
                }
            }
        };
        this.func_230480_a_((Widget)this.rsButton);
        if (this.hasFilter) {
            String[] whitelistStates = new String[]{"blacklist", "whitelist"};
            int currentWhitelistState = this.te.isWhitelist() ? 1 : 0;
            this.whitelistButton = new IconButton(this.field_147003_i + 148, this.field_147009_r + 17, whitelistStates, currentWhitelistState, background, 0, 204){

                @Override
                public void updateState(int currentState) {
                    DemagnetizerGui.this.te.setWhitelist(currentState == 1);
                }
            };
            this.func_230480_a_((Widget)this.whitelistButton);
        }
    }

    protected void func_230450_a_(@Nonnull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(background);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, 176, 166);
        for (int i = 0; i < this.te.getFilterSize(); ++i) {
            this.func_238474_b_(stack, this.field_147003_i + 7 + i * 18, this.field_147009_r + 52, 0, 166, 18, 18);
        }
    }

    protected void func_230451_b_(@Nonnull MatrixStack stack, int mouseX, int mouseY) {
        String demagName = this.field_230704_d_.getString();
        int centeredPos = (this.field_146999_f - this.field_230712_o_.func_78256_a(demagName)) / 2;
        this.field_230712_o_.func_238421_b_(stack, demagName, (float)centeredPos, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(stack, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        if (this.hasFilter) {
            this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"label.demagnetize.demagnetizer.filter", (Object[])new Object[0]), 8.0f, 42.0f, 0x404040);
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
        this.rsButton.renderTooltip(stack, mouseX, mouseY);
        if (this.hasFilter) {
            this.whitelistButton.renderTooltip(stack, mouseX, mouseY);
        }
    }

    public void func_231175_as__() {
        this.te.sendSettingsToServer();
        super.func_231175_as__();
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.func_241217_q_() != null && this.func_231041_ay__() && button == 0 && this.func_241217_q_().func_231045_a_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public abstract class IconButton
    extends AbstractButton {
        private final String[] stateList;
        private int currentState;
        private final ResourceLocation location;
        private final int resourceX;
        private final int resourceY;

        IconButton(int x, int y, String[] stateList, int currentState, ResourceLocation location, int resourceX, int resourceY) {
            super(x, y, 20, 20, StringTextComponent.field_240750_d_);
            this.stateList = stateList;
            this.currentState = currentState;
            this.location = location;
            this.resourceX = resourceX;
            this.resourceY = resourceY;
        }

        public void func_230431_b_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(stack, mouseX, mouseY, partialTicks);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(this.location);
            this.func_238474_b_(stack, this.field_230690_l_, this.field_230691_m_, this.resourceX + this.currentState * this.field_230688_j_, this.resourceY, this.field_230688_j_, this.field_230689_k_);
        }

        void renderTooltip(MatrixStack stack, int mouseX, int mouseY) {
            if (this.func_230449_g_()) {
                DemagnetizerGui.this.func_238652_a_(stack, (ITextComponent)this.func_230442_c_(), mouseX, mouseY);
            }
        }

        @Nonnull
        protected IFormattableTextComponent func_230442_c_() {
            return new TranslationTextComponent("label.demagnetize.demagnetizer." + this.stateList[this.currentState]);
        }

        public void func_230930_b_() {
            ++this.currentState;
            if (this.currentState >= this.stateList.length) {
                this.currentState = 0;
            }
            this.updateState(this.currentState);
        }

        public abstract void updateState(int var1);
    }

    private class RangeSlider
    extends AbstractSlider {
        private int scaledValue;
        private final int maxValue;
        private static final int minValue = 1;

        RangeSlider(int x, int y, int maxRange, int value) {
            super(x, y, 113, 20, StringTextComponent.field_240750_d_, (double)((float)(value - 1) / (float)(maxRange - 1)));
            this.scaledValue = value;
            this.maxValue = maxRange;
            this.func_230979_b_();
        }

        protected void func_230979_b_() {
            this.func_238482_a_((ITextComponent)new TranslationTextComponent("label.demagnetize.demagnetizer.range").func_240702_b_(": " + this.scaledValue));
        }

        protected void func_230972_a_() {
            this.scaledValue = (int)(Math.round(this.field_230683_b_ * (double)(this.maxValue - 1)) + 1L);
            DemagnetizerGui.this.te.setRange(this.scaledValue);
        }
    }
}

