/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.delogger;

import com.unrealdinnerbone.delogger.DeLoggerConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.AbstractFilter;

public class LoggerFilter
extends AbstractFilter {
    private final DeLoggerConfig deLoggerConfig;

    public LoggerFilter(DeLoggerConfig deLoggerConfig) {
        this.deLoggerConfig = deLoggerConfig;
    }

    public Filter.Result filter(LogEvent event) {
        if (event.getLevel() == Level.ERROR && event.getThrown() != null) {
            if (this.deLoggerConfig.ignoredExceptions.contains(event.getThrown().getClass().getCanonicalName())) {
                return Filter.Result.DENY;
            }
            if (this.deLoggerConfig.loggers.contains(event.getLoggerName())) {
                return Filter.Result.DENY;
            }
        } else {
            if (this.deLoggerConfig.loggers.contains(event.getLoggerName())) {
                return Filter.Result.DENY;
            }
            if (event.getLoggerName().equals("STDOUT")) {
                String s = event.getMessage().getFormattedMessage();
                for (String logger : this.deLoggerConfig.loggers) {
                    logger = "[" + logger;
                    if (!s.startsWith(logger)) continue;
                    return Filter.Result.DENY;
                }
            }
        }
        return super.filter(event);
    }
}

