/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.enderhopper;

import net.darkhax.bookshelf.util.InventoryUtils;
import net.darkhax.darkutils.features.enderhopper.TileEntityEnderHopper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class BlockEnderHopper
extends Block
implements IBucketPickupHandler,
ILiquidContainer {
    private static final AbstractBlock.Properties PROPERTIES = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(50.0f, 1200.0f);
    protected static final BooleanProperty SHOW_BORDER = BooleanProperty.func_177716_a((String)"darkutils_show_border");
    private static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_UP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockEnderHopper() {
        super(PROPERTIES);
        BlockState defaultState = this.func_176223_P();
        defaultState = (BlockState)defaultState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP);
        defaultState = (BlockState)defaultState.func_206870_a((Property)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(true));
        defaultState = (BlockState)defaultState.func_206870_a((Property)SHOW_BORDER, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
        this.func_180632_j(defaultState);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SHOW_BORDER, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)SHOW_BORDER) == false)));
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState preExistingFluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState placedState = this.func_176223_P();
        placedState = (BlockState)placedState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)context.func_196000_l());
        placedState = (BlockState)placedState.func_206870_a((Property)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(BlockEnderHopper.hasInventory(context.func_195991_k(), context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d()), context.func_196000_l())));
        placedState = (BlockState)placedState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(preExistingFluidState.func_206886_c() == Fluids.field_204546_a));
        return placedState;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case UP: {
                return SHAPE_UP;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_UP;
    }

    public boolean func_181623_g() {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, BlockStateProperties.field_208180_g, SHOW_BORDER, BlockStateProperties.field_208198_y});
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return true;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a && !worldIn.func_201670_d()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
        }
        return false;
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState myState, Direction facing, BlockState facingState, IWorld world, BlockPos myPos, BlockPos facingPos) {
        if (((Boolean)myState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(myPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing.func_176734_d() == myState.func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            return (BlockState)myState.func_206870_a((Property)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(BlockEnderHopper.hasInventory((World)world, facingPos, facing.func_176734_d())));
        }
        return super.func_196271_a(myState, facing, facingState, world, myPos, facingPos);
    }

    private static boolean hasInventory(World world, BlockPos pos, Direction facing) {
        IItemHandler inventory = InventoryUtils.getInventory((World)world, (BlockPos)pos, (Direction)facing);
        return inventory != null && inventory != EmptyHandler.INSTANCE && inventory.getSlots() > 0;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityEnderHopper();
    }
}

