/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.charms;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.addons.curios.CuriosAddon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.ModList;

public class CharmEffects {
    public static void applySleepCharmEffect(Entity user, ItemStack item) {
        if (user instanceof PlayerEntity) {
            if (((PlayerEntity)user).func_70608_bn()) {
                ((PlayerEntity)user).field_71076_b = 100;
            }
            if (user instanceof ServerPlayerEntity) {
                Stat sleepStat = Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n);
                ServerStatisticsManager statsManager = ((ServerPlayerEntity)user).func_147099_x();
                int timeSinceLastSlept = statsManager.func_77444_a(sleepStat);
                statsManager.func_150873_a((PlayerEntity)user, sleepStat, Math.max(timeSinceLastSlept - 100, 0));
            }
        }
    }

    public static void applyPortalCharmEffect(Entity user, ItemStack item) {
        if (user instanceof PlayerEntity) {
            ((PlayerEntity)user).field_82153_h = 100;
        }
    }

    public static void applyExperienceCharmTickEffect(Entity user, ItemStack item) {
        if (user instanceof PlayerEntity) {
            ((PlayerEntity)user).field_71090_bL = 0;
        }
    }

    public static void handleExpCharmEntity(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() != null) {
            Item charm = DarkUtils.content.experienceCharm;
            PlayerEntity player = event.getAttackingPlayer();
            if (CharmEffects.getStacksFromPlayer(player, charm).size() > 0) {
                event.setDroppedExperience(event.getDroppedExperience() + event.getEntity().field_70170_p.field_73012_v.nextInt(5));
            }
        }
    }

    public static void handleExpCharmBlock(BlockEvent.BreakEvent event) {
        if (event.getExpToDrop() > 0 && event.getPlayer() != null) {
            Item charm = DarkUtils.content.experienceCharm;
            PlayerEntity player = event.getPlayer();
            if (CharmEffects.getStacksFromPlayer(player, charm).size() > 0) {
                event.setExpToDrop(event.getExpToDrop() + event.getWorld().func_201674_k().nextInt(5));
            }
        }
    }

    public static void handleGluttonCharm(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            Item charm = DarkUtils.content.gluttonyCharm;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack using = event.getItem();
            if ((using.func_222117_E() || using.func_77975_n() == UseAction.DRINK || using.func_77975_n() == UseAction.EAT) && CharmEffects.getStacksFromPlayer(player, charm).size() > 0) {
                event.setDuration(1);
            }
        }
    }

    public static List<ItemStack> getStacksFromPlayer(PlayerEntity player, Item item) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (ModList.get().isLoaded("curios")) {
            stacks.addAll(CuriosAddon.getStacksFromPlayer(player, item));
        }
        stacks.addAll(PlayerUtils.getStacksFromPlayer((PlayerEntity)player, (Item)item));
        return stacks;
    }
}

