/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.blockentity.DockBlockEntity;
import tfar.dankstorage.item.DankItem;

public class DockBlock
extends Block {
    public static final IntegerProperty TIER = IntegerProperty.func_177719_a((String)"tier", (int)0, (int)7);
    public static final VoxelShape EMPTY;
    public static final VoxelShape DOCKED;

    public DockBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        PlayerEntity player;
        if (context.getEntity() instanceof PlayerEntity && (player = (PlayerEntity)context.getEntity()).func_184614_ca().func_77973_b() instanceof DankItem) {
            return DOCKED;
        }
        return (Integer)state.func_177229_b((Property)TIER) > 0 ? DOCKED : EMPTY;
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof DockBlockEntity) {
            DockBlockEntity dock = (DockBlockEntity)tile;
            if (dock.numPlayersUsing > 0) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.dankstorage.in_use").func_240699_a_(TextFormatting.RED), true);
                return ActionResultType.FAIL;
            }
            if (!world.field_72995_K) {
                ItemStack held = player.func_184586_b(hand);
                if (player.func_213453_ef() && held.func_77973_b().func_206844_a(ModTags.WRENCHES)) {
                    world.func_225521_a_(pos, true, (Entity)player);
                    return ActionResultType.SUCCESS;
                }
                if (held.func_77973_b() instanceof DankItem) {
                    if ((Integer)state.func_177229_b((Property)TIER) > 0) {
                        dock.removeTank();
                    }
                    dock.addTank(held);
                    return ActionResultType.SUCCESS;
                }
                if (held.func_190926_b() && player.func_225608_bj_() && (Integer)state.func_177229_b((Property)TIER) > 0) {
                    dock.removeTank();
                    return ActionResultType.SUCCESS;
                }
                if ((Integer)state.func_177229_b((Property)TIER) > 0) {
                    player.func_213829_a((INamedContainerProvider)dock);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        ItemStack bag = ctx.func_195996_i();
        Block block = Block.func_149634_a((Item)bag.func_77973_b());
        if (block instanceof DockBlock) {
            return block.func_176223_P();
        }
        return block.isAir(block.func_176223_P(), null, null) ? null : block.func_196258_a(ctx);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DockBlockEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TIER});
    }

    static {
        VoxelShape a1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        VoxelShape b1 = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        VoxelShape shape1 = VoxelShapes.func_197882_b((VoxelShape)a1, (VoxelShape)b1, (IBooleanFunction)IBooleanFunction.field_223236_g_);
        VoxelShape a2 = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape b2 = Block.func_208617_a((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape shape2 = VoxelShapes.func_197882_b((VoxelShape)a2, (VoxelShape)b2, (IBooleanFunction)IBooleanFunction.field_223236_g_);
        VoxelShape p1 = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0);
        VoxelShape p2 = Block.func_208617_a((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0);
        VoxelShape p3 = Block.func_208617_a((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0);
        VoxelShape p4 = Block.func_208617_a((double)12.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
        EMPTY = VoxelShapes.func_216384_a((VoxelShape)shape1, (VoxelShape[])new VoxelShape[]{shape2, p1, p2, p3, p4});
        DOCKED = VoxelShapes.func_197872_a((VoxelShape)EMPTY, (VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }
}

