/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;
import tfar.dankstorage.block.DockBlock;
import tfar.dankstorage.blockentity.DockBlockEntity;
import tfar.dankstorage.container.DockContainer;
import tfar.dankstorage.container.PortableDankContainer;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.item.UpgradeInfo;
import tfar.dankstorage.item.UpgradeItem;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.recipe.Serializer2;
import tfar.dankstorage.utils.DankMenuType;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.Utils;

@Mod(value="dankstorage")
public class DankStorage {
    public static final String MODID = "dankstorage";
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public DankStorage() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::drop);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sync);
    }

    private void sync(ModConfig.ModConfigEvent e) {
        if (e.getConfig().getModId().equals(MODID)) {
            Utils.taglist.clear();
            ((List)ServerConfig.convertible_tags.get()).forEach(s -> Utils.taglist.add(new ResourceLocation(s)));
            DankStats.one.setStacklimit((Integer)ServerConfig.stacklimit1.get());
            DankStats.two.setStacklimit((Integer)ServerConfig.stacklimit2.get());
            DankStats.three.setStacklimit((Integer)ServerConfig.stacklimit3.get());
            DankStats.four.setStacklimit((Integer)ServerConfig.stacklimit4.get());
            DankStats.five.setStacklimit((Integer)ServerConfig.stacklimit5.get());
            DankStats.six.setStacklimit((Integer)ServerConfig.stacklimit6.get());
            DankStats.seven.setStacklimit((Integer)ServerConfig.stacklimit7.get());
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        DankPacketHandler.registerMessages(MODID);
    }

    private void drop(ItemTossEvent event) {
        if (event.getEntityItem().func_92059_d().func_77973_b() instanceof DankItem) {
            event.getEntityItem().func_184224_h(true);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair2.getRight();
        SERVER = (ServerConfig)specPair2.getLeft();
    }

    @ObjectHolder(value="dankstorage")
    public static class Objects {
        public static final Block dock = null;
        public static final ContainerType<DockContainer> dank_1_container = null;
        public static final ContainerType<DockContainer> dank_2_container = null;
        public static final ContainerType<DockContainer> dank_3_container = null;
        public static final ContainerType<DockContainer> dank_4_container = null;
        public static final ContainerType<DockContainer> dank_5_container = null;
        public static final ContainerType<DockContainer> dank_6_container = null;
        public static final ContainerType<DockContainer> dank_7_container = null;
        public static final ContainerType<PortableDankContainer> portable_dank_1_container = null;
        public static final ContainerType<PortableDankContainer> portable_dank_2_container = null;
        public static final ContainerType<PortableDankContainer> portable_dank_3_container = null;
        public static final ContainerType<PortableDankContainer> portable_dank_4_container = null;
        public static final ContainerType<PortableDankContainer> portable_dank_5_container = null;
        public static final ContainerType<PortableDankContainer> portable_dank_6_container = null;
        public static final ContainerType<PortableDankContainer> portable_dank_7_container = null;
        public static final TileEntityType<?> dank_tile = null;
        public static final IRecipeSerializer<?> upgrade = null;
    }

    public static class ServerConfig {
        public static ForgeConfigSpec.IntValue stacklimit1;
        public static ForgeConfigSpec.IntValue stacklimit2;
        public static ForgeConfigSpec.IntValue stacklimit3;
        public static ForgeConfigSpec.IntValue stacklimit4;
        public static ForgeConfigSpec.IntValue stacklimit5;
        public static ForgeConfigSpec.IntValue stacklimit6;
        public static ForgeConfigSpec.IntValue stacklimit7;
        public static ForgeConfigSpec.BooleanValue useShareTag;
        public static ForgeConfigSpec.ConfigValue<List<String>> convertible_tags;
        public static final List<String> defaults;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            stacklimit1 = builder.comment("Stack limit of first dank storage").defineInRange("stacklimit1", 256, 1, Integer.MAX_VALUE);
            stacklimit2 = builder.comment("Stack limit of second dank storage").defineInRange("stacklimit2", 1024, 1, Integer.MAX_VALUE);
            stacklimit3 = builder.comment("Stack limit of third dank storage").defineInRange("stacklimit3", 4096, 1, Integer.MAX_VALUE);
            stacklimit4 = builder.comment("Stack limit of fourth dank storage").defineInRange("stacklimit4", 16384, 1, Integer.MAX_VALUE);
            stacklimit5 = builder.comment("Stack limit of fifth dank storage").defineInRange("stacklimit5", 65536, 1, Integer.MAX_VALUE);
            stacklimit6 = builder.comment("Stack limit of sixth dank storage").defineInRange("stacklimit6", 262144, 1, Integer.MAX_VALUE);
            stacklimit7 = builder.comment("Stack limit of seventh dank storage").defineInRange("stacklimit7", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            convertible_tags = builder.comment("Tags that are eligible for conversion, input as a list of resourcelocation, eg 'forge:ingots/iron'").define("convertible tags", defaults);
            useShareTag = builder.comment("Use Share Tag instead of full NBT to reduce the chance of NBT oversending causing clients to be disconnected.  Warning: this will cause the Dank\nStorage to wipe it's items in Creative Mode.  There is nothing I can do about this as it is a vanilla bug.").define("useShareTag", false);
            builder.pop();
        }

        static {
            defaults = Lists.newArrayList((Object[])new String[]{"forge:ingots/iron", "forge:ingots/gold", "forge:ores/coal", "forge:ores/diamond", "forge:ores/emerald", "forge:ores/gold", "forge:ores/iron", "forge:ores/lapis", "forge:ores/redstone", "forge:gems/amethyst", "forge:gems/peridot", "forge:gems/ruby", "forge:ingots/copper", "forge:ingots/lead", "forge:ingots/nickel", "forge:ingots/silver", "forge:ingots/tin", "forge:ores/copper", "forge:ores/lead", "forge:ores/ruby", "forge:ores/silver", "forge:ores/tin"});
        }
    }

    public static class ClientConfig {
        public static ForgeConfigSpec.BooleanValue preview;
        public static ForgeConfigSpec.IntValue hudX;
        public static ForgeConfigSpec.IntValue hudY;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            preview = builder.comment("Whether to display the preview of the item in the dank, disable if you have optifine").define("preview", true);
            builder.pop();
            hudX = builder.comment("X position of dank hud element").defineInRange("hudX", -150, Integer.MIN_VALUE, Integer.MAX_VALUE);
            hudY = builder.comment("Y position of dank hud element").defineInRange("hudY", -25, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void blocks(RegistryEvent.Register<Block> event) {
            AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 60.0f);
            RegistryEvents.register(new DockBlock(properties), "dock", event.getRegistry());
        }

        @SubscribeEvent
        public static void items(RegistryEvent.Register<Item> event) {
            Item.Properties properties = new Item.Properties().func_200916_a(ItemGroup.field_78031_c);
            RegistryEvents.register(new BlockItem(Objects.dock, properties), Objects.dock.getRegistryName().func_110623_a(), event.getRegistry());
            IntStream.range(1, 8).forEach(i -> RegistryEvents.register(new DankItem(properties.func_200917_a(1), DankStats.fromInt(i)), "dank_" + i, event.getRegistry()));
            IntStream.range(1, 7).forEach(i -> RegistryEvents.register(new UpgradeItem(properties, new UpgradeInfo(i, DankStats.fromInt(i + 1))), i + "_to_" + (i + 1), event.getRegistry()));
        }

        @SubscribeEvent
        public static void recipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            RegistryEvents.register(new Serializer2(), "upgrade", event.getRegistry());
        }

        @SubscribeEvent
        public static void containers(RegistryEvent.Register<ContainerType<?>> event) {
            RegistryEvents.register(new DankMenuType(DockContainer::dock1c, DankStats.one), "dank_1_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(PortableDankContainer::dank1c, DankStats.one), "portable_dank_1_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(DockContainer::dock2c, DankStats.two), "dank_2_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(PortableDankContainer::dank2c, DankStats.two), "portable_dank_2_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(DockContainer::dock3c, DankStats.three), "dank_3_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(PortableDankContainer::dank3c, DankStats.three), "portable_dank_3_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(DockContainer::dock4c, DankStats.four), "dank_4_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(PortableDankContainer::dank4c, DankStats.four), "portable_dank_4_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(DockContainer::dock5c, DankStats.five), "dank_5_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(PortableDankContainer::dank5c, DankStats.five), "portable_dank_5_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(DockContainer::dock6c, DankStats.six), "dank_6_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(PortableDankContainer::dank6c, DankStats.six), "portable_dank_6_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(DockContainer::dock7c, DankStats.seven), "dank_7_container", event.getRegistry());
            RegistryEvents.register(new DankMenuType(PortableDankContainer::dank7c, DankStats.seven), "portable_dank_7_container", event.getRegistry());
        }

        @SubscribeEvent
        public static void tiles(RegistryEvent.Register<TileEntityType<?>> event) {
            RegistryEvents.register(TileEntityType.Builder.func_223042_a(DockBlockEntity::new, (Block[])new Block[]{Objects.dock}).func_206865_a(null), "dank_tile", event.getRegistry());
        }

        private static <T extends IForgeRegistryEntry<T>> void register(T obj, String name, IForgeRegistry<T> registry) {
            registry.register((IForgeRegistryEntry)obj.setRegistryName(new ResourceLocation(DankStorage.MODID, name)));
        }
    }
}

