/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMap;

public interface IIngredientMapMutable<T, M, V>
extends IIngredientMap<T, M, V> {
    public void clear();

    @Nullable
    public V put(T var1, V var2);

    @Nullable
    public V remove(T var1);

    public int removeAll(T var1, M var2);

    default public int removeAll(Iterable<? extends T> instances) {
        int removed = 0;
        for (T instance : instances) {
            if (this.remove(instance) == null) continue;
            ++removed;
        }
        return removed;
    }

    default public int removeAll(Iterable<? extends T> instances, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            int size = this.size();
            this.clear();
            return size;
        }
        int removed = 0;
        for (T instance : instances) {
            removed += this.removeAll(instance, matchCondition);
        }
        return removed;
    }

    default public int putAll(IIngredientMap<? extends T, M, ? extends V> map) {
        for (Map.Entry<T, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return map.size();
    }
}

