/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;

public abstract class ConfigurableTypeAction<C extends ExtendedConfig<C, I>, I> {
    public void onRegisterModInit(C eConfig) {
    }

    public void onRegisterForge(C eConfig) {
    }

    public void onRegisterForgeFilled(C eConfig) {
    }

    public void onRegisterSetup(C eConfig) {
    }

    public static <C extends ExtendedConfigForge<C, I>, I extends IForgeRegistryEntry<? super I>> void register(C config) {
        ConfigurableTypeAction.register(config, () -> {
            config.onForgeRegistered();
            return null;
        });
    }

    public static <C extends ExtendedConfigForge<C, I>, I extends IForgeRegistryEntry<? super I>> void register(C config, @Nullable Callable<?> callback) {
        ConfigurableTypeAction.register(Objects.requireNonNull(config.getRegistry(), "Tried registering a config for which no registry exists: " + config.getNamedId()), config, callback);
    }

    public static <C extends ExtendedConfigForge<C, I>, I extends IForgeRegistryEntry<? super I>> void register(IForgeRegistry<? super I> registry, C config) {
        ConfigurableTypeAction.register(registry, config, null);
    }

    public static <C extends ExtendedConfigForge<C, I>, I extends IForgeRegistryEntry<? super I>> void register(IForgeRegistry<? super I> registry, C config, @Nullable Callable<?> callback) {
        config.getMod().getConfigHandler().registerToRegistry(registry, config, callback);
    }
}

