/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;

public class WidgetArrowedListField<E>
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowLeft;
    private ButtonArrow arrowRight;
    private List<E> elements;
    private int activeElement;
    private IInputListener listener;

    public WidgetArrowedListField(FontRenderer fontrenderer, int x, int y, int width, int height, boolean arrows, ITextComponent narrationMessage, boolean background, List<E> elements) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowLeft = new ButtonArrow(x, y - 1, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.left"), button -> this.decrease(), ButtonArrow.Direction.WEST);
            this.arrowRight = new ButtonArrow(x + width, y - 1, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.right"), button -> this.increase(), ButtonArrow.Direction.EAST);
            this.arrowRight.field_230690_l_ -= this.arrowRight.func_230998_h_();
        }
        this.func_146185_a(true);
        this.elements = elements;
        this.setActiveElement(0);
    }

    @Override
    public void setListener(IInputListener listener) {
        this.listener = listener;
    }

    public boolean func_146181_i() {
        return false;
    }

    public void setActiveElement(int index) {
        if (index >= this.elements.size()) {
            this.activeElement = -1;
            this.func_146180_a("");
        } else {
            this.activeElement = index;
            this.func_146180_a(this.activeElementToString(this.getActiveElement()));
        }
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public boolean setActiveElement(E element) {
        int index = this.elements.indexOf(element);
        if (index < 0) {
            return false;
        }
        this.setActiveElement(index);
        return true;
    }

    protected String activeElementToString(E element) {
        return element.toString();
    }

    public E getActiveElement() throws NumberFormatException {
        if (this.activeElement < 0 || this.activeElement >= this.elements.size()) {
            return null;
        }
        return this.elements.get(this.activeElement);
    }

    @Override
    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowLeft.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            this.arrowRight.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            offsetX = this.arrowLeft.func_230998_h_();
            this.field_230690_l_ += offsetX + 1;
            this.field_230688_j_ -= offsetX * 2;
        }
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.field_230690_l_ -= offsetX + 1;
            this.field_230688_j_ += offsetX * 2;
        }
    }

    protected void increase() {
        this.setActiveElement((this.activeElement + 1) % this.elements.size());
    }

    protected void decrease() {
        this.setActiveElement((this.activeElement - 1 + this.elements.size()) % this.elements.size());
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        return this.arrowLeft.func_231044_a_(mouseX, mouseY, mouseButton) || this.arrowRight.func_231044_a_(mouseX, mouseY, mouseButton) || super.func_231044_a_(mouseX, mouseY, mouseButton);
    }
}

