/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.config.ClientConfigCyclic;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.CyclicFile;
import com.lothrazar.cyclic.data.RelativeShape;
import com.lothrazar.cyclic.event.PlayerDataEvents;
import com.lothrazar.cyclic.item.OreProspector;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.item.builder.PacketSwapBlock;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.item.random.RandomizerItem;
import com.lothrazar.cyclic.util.UtilPlayer;
import com.lothrazar.cyclic.util.UtilRender;
import com.lothrazar.cyclic.util.UtilWorld;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventRender {
    @SubscribeEvent
    public void overlay(RenderGameOverlayEvent.Post event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            BlockState targetState;
            ItemStack itemStackHeld = BuilderItem.getIfHeld((PlayerEntity)player);
            if (itemStackHeld.func_77973_b() instanceof BuilderItem && (targetState = BuilderActionType.getBlockState(itemStackHeld)) != null) {
                EventRender.drawStack(new ItemStack((IItemProvider)targetState.func_177230_c()));
                int slot = UtilPlayer.getFirstSlotWithBlock((PlayerEntity)player, targetState);
                if (slot < 0) {
                    int width = mc.func_228018_at_().func_198107_o();
                    int height = mc.func_228018_at_().func_198087_p();
                    EventRender.drawString(event.getMatrixStack(), "0", width / 2 + 16, height / 2 + 12);
                }
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            int sec;
            int height = mc.func_228018_at_().func_198087_p();
            CyclicFile datFile = PlayerDataEvents.getOrCreate((PlayerEntity)player);
            if (datFile.flyTicks > 0) {
                sec = datFile.flyTicks / 20;
                EventRender.drawString(event.getMatrixStack(), "flight " + sec, 10, height - 30);
            }
            if (datFile.spectatorTicks > 0) {
                sec = datFile.spectatorTicks / 20;
                EventRender.drawString(event.getMatrixStack(), "noClip " + sec, 10, height - 10);
            }
        }
    }

    public static void drawString(MatrixStack ms, String str, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_238421_b_(ms, str, (float)x, (float)y, 0xFFFFFF);
    }

    public static void drawStack(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        int width = mc.func_228018_at_().func_198107_o();
        int height = mc.func_228018_at_().func_198087_p();
        mc.func_175599_af().func_180450_b(stack, width / 2, height / 2);
    }

    @SubscribeEvent
    public void renderOverlay(RenderWorldLastEvent event) {
        RelativeShape shape;
        BlockPosDim loc;
        Object buildStyle;
        BlockRayTraceResult lookingAt;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        double range = 6.0;
        float alpha = 0.25f;
        HashMap<BlockPos, Color> renderCubes = new HashMap<BlockPos, Color>();
        ItemStack stack = BuilderItem.getIfHeld((PlayerEntity)player);
        if (stack.func_77973_b() instanceof BuilderItem && !world.func_175623_d((lookingAt = (BlockRayTraceResult)player.func_213324_a(range, 0.0f, false)).func_216350_a())) {
            BlockPos pos = lookingAt.func_216350_a();
            buildStyle = ((BuilderItem)stack.func_77973_b()).style;
            if (buildStyle.isOffset() && lookingAt.func_216354_b() != null) {
                pos = pos.func_177972_a(lookingAt.func_216354_b());
            }
            alpha = 0.4f;
            List<BlockPos> coordinates = PacketSwapBlock.getSelectedBlocks(world, pos, BuilderItem.getActionType(stack), lookingAt.func_216354_b(), buildStyle);
            for (BlockPos coordinate : coordinates) {
                renderCubes.put(coordinate, ClientConfigCyclic.getColor(stack));
            }
        }
        if ((stack = RandomizerItem.getIfHeld((PlayerEntity)player)).func_77973_b() instanceof RandomizerItem) {
            lookingAt = UtilRender.getLookingAt((PlayerEntity)player, (int)range);
            if (player.field_70170_p.func_180495_p(lookingAt.func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
                return;
            }
            List<BlockPos> coords = RandomizerItem.getPlaces(lookingAt.func_216350_a(), lookingAt.func_216354_b());
            buildStyle = coords.iterator();
            while (buildStyle.hasNext()) {
                BlockPos e;
                renderCubes.put(e, RandomizerItem.canMove(player.field_70170_p.func_180495_p(e = (BlockPos)buildStyle.next()), player.field_70170_p, e) ? ClientConfigCyclic.getColor(stack) : Color.RED);
            }
        }
        if ((stack = OreProspector.getIfHeld((PlayerEntity)player)).func_77973_b() instanceof OreProspector) {
            ArrayList<BlockPosDim> coords = OreProspector.getPosition(stack);
            for (BlockPosDim loc2 : coords) {
                if (loc2 == null || loc2.getDimension() != null && !loc2.getDimension().equalsIgnoreCase(UtilWorld.dimensionToString(world))) continue;
                UtilRender.createBox(event.getMatrixStack(), loc2.getPos());
            }
        }
        if ((stack = player.func_184614_ca()).func_77973_b() instanceof LocationGpsCard && (loc = LocationGpsCard.getPosition(stack)) != null && (loc.getDimension() == null || loc.getDimension().equalsIgnoreCase(UtilWorld.dimensionToString(world)))) {
            renderCubes.put(loc.getPos(), ClientConfigCyclic.getColor(stack));
        }
        if (stack.func_77973_b() instanceof ShapeCard && (shape = RelativeShape.read(stack)) != null) {
            BlockPos here = player.func_233580_cy_();
            for (BlockPos s : shape.getShape()) {
                renderCubes.put(here.func_177971_a((Vector3i)s), ClientConfigCyclic.getColor(stack));
            }
        }
        if (renderCubes.keySet().size() > 0) {
            UtilRender.renderColourCubes(event, renderCubes, alpha);
        }
    }
}

