/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.registry.EnchantRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantXp
extends EnchantBase {
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "experience_boost";

    public EnchantXp(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... mainhand) {
        super(rarityIn, typeIn, mainhand);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return CFG == null || (Boolean)CFG.get() != false;
    }

    @SubscribeEvent
    public void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        int level = this.getCurrentLevelTool(event.getPlayer().func_184614_ca());
        if (level <= 0) {
            return;
        }
        event.setExpToDrop(event.getExpToDrop() + this.getRandomExpAmount(level, event.getPlayer().field_70170_p));
    }

    @SubscribeEvent
    public void handleEntityDropEvent(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        int level = this.getCurrentLevelTool(event.getAttackingPlayer().func_184614_ca());
        if (level <= 0) {
            return;
        }
        event.setDroppedExperience(event.getDroppedExperience() + this.getRandomExpAmount(level, event.getAttackingPlayer().field_70170_p));
    }

    private int getRandomExpAmount(int level, World world) {
        return world.field_73012_v.nextInt(this.func_77325_b()) * (level + 1);
    }

    public boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != EnchantRegistry.EXCAVATE;
    }

    public int func_77325_b() {
        return 3;
    }
}

