/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.ItemStackHandler;

public class CyclicFile {
    public static final String NBTINV = "inv";
    public final UUID playerId;
    public boolean storageVisible = false;
    public boolean todoVisible = false;
    public boolean stepHeight = false;
    public List<String> todoTasks = new ArrayList<String>();
    public int flyTicks = 0;
    public int spectatorTicks = 0;
    public ItemStackHandler inventory = new ItemStackHandler(45);
    public boolean stepHeightForceOff;

    public String toString() {
        return "CyclicFile [playerId=" + this.playerId + ", storageVisible=" + this.storageVisible + ", todoVisible=" + this.todoVisible + ", stepHeight=" + this.stepHeight + ", todoTasks=" + this.todoTasks + ", flyTicks=" + this.flyTicks + ", spectatorTicks=" + this.spectatorTicks + ", inventory=" + this.inventory + ", stepHeightForceOff=" + this.stepHeightForceOff + "]";
    }

    public CyclicFile(UUID playerId) {
        this.playerId = playerId;
    }

    public void read(CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l(NBTINV));
        this.flyTicks = tag.func_74762_e("flyTicks");
        this.spectatorTicks = tag.func_74762_e("spectatorTicks");
        this.storageVisible = tag.func_74767_n("storageVisible");
        this.stepHeightForceOff = tag.func_74767_n("stepHeightForceOff");
        this.stepHeight = tag.func_74767_n("stepHeight");
        if (tag.func_74764_b("tasks")) {
            ListNBT glist = tag.func_150295_c("tasks", 10);
            for (int i = 0; i < glist.size(); ++i) {
                CompoundNBT row = glist.func_150305_b(i);
                this.todoTasks.add(row.func_74779_i("todo"));
            }
        }
    }

    public CompoundNBT write() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBTINV, (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("flyTicks", this.flyTicks);
        tag.func_74768_a("spectatorTicks", this.spectatorTicks);
        tag.func_74757_a("stepHeight", this.stepHeight);
        tag.func_74757_a("stepHeightForceOff", this.stepHeightForceOff);
        tag.func_74757_a("storageVisible", this.storageVisible);
        ListNBT glist = new ListNBT();
        int i = 0;
        for (String t : this.todoTasks) {
            CompoundNBT row = new CompoundNBT();
            row.func_74768_a("index", i);
            row.func_74778_a("todo", t);
            glist.add((Object)row);
        }
        tag.func_218657_a("tasks", (INBT)glist);
        return tag;
    }

    public void toggleStepHeight() {
        boolean bl = this.stepHeight = !this.stepHeight;
        if (!this.stepHeight) {
            this.stepHeightForceOff = true;
        }
    }
}

