/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerWrapper
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundNBT> {
    public static final String NBT_INPUT = "Input";
    public static final String NBT_OUTPUT = "Output";
    protected final ItemStackHandler input;
    protected final ItemStackHandler output;

    public ItemStackHandlerWrapper(ItemStackHandler input, ItemStackHandler output) {
        this.input = input;
        this.output = output;
    }

    protected <T> T withHandler(int externalSlot, HandlerCallback<T> callback) {
        int numInputSlots = this.input.getSlots();
        boolean isInput = externalSlot < numInputSlots;
        int internalSlot = isInput ? externalSlot : externalSlot - numInputSlots;
        ItemStackHandler handler = isInput ? this.input : this.output;
        return callback.apply(handler, internalSlot, isInput);
    }

    protected void withHandlerV(int slot, HandlerCallbackVoid func) {
        this.withHandler(slot, (h, s, isInput) -> {
            func.apply(h, s, isInput);
            return false;
        });
    }

    public int getSlots() {
        return this.input.getSlots() + this.output.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.withHandler(slot, (h, s, isInput) -> h.getStackInSlot(s));
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.withHandler(slot, (h, s, isInput) -> isInput ? h.insertItem(s, stack, simulate) : stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.withHandler(slot, (h, s, isInput) -> isInput ? ItemStack.field_190927_a : h.extractItem(s, amount, simulate));
    }

    public int getSlotLimit(int slot) {
        return this.withHandler(slot, (h, s, isInput) -> h.getSlotLimit(s));
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.withHandler(slot, (h, s, isInput) -> isInput && h.isItemValid(s, stack));
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.withHandlerV(slot, (h, s, isInput) -> h.setStackInSlot(s, stack));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_218657_a(NBT_INPUT, (INBT)this.input.serializeNBT());
        cmp.func_218657_a(NBT_OUTPUT, (INBT)this.output.serializeNBT());
        return cmp;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.input.deserializeNBT(nbt.func_74775_l(NBT_INPUT));
        this.output.deserializeNBT(nbt.func_74775_l(NBT_OUTPUT));
    }

    @FunctionalInterface
    protected static interface HandlerCallback<T> {
        public T apply(ItemStackHandler var1, int var2, boolean var3);
    }

    @FunctionalInterface
    protected static interface HandlerCallbackVoid {
        public void apply(ItemStackHandler var1, int var2, boolean var3);
    }
}

