/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.forester;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.forester.ContainerForester;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileForester
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 64000;
    static final int MAX_HEIGHT = 32;
    private static final int MAX_SIZE = 12;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private int height = 32;
    private int radius = 12;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileForester.this.isSapling(stack);
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private WeakReference<FakePlayer> fakePlayer;
    private int shapeIndex = 0;

    public TileForester() {
        super(TileRegistry.FORESTER);
        this.needsRedstone = 1;
        this.render = 0;
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return;
        }
        ++this.shapeIndex;
        BlockPos targetPos = this.getShapeTarget(shape);
        this.skipSomeAirBlocks(shape);
        try {
            ActionResultType result;
            if (this.fakePlayer == null && this.field_145850_b instanceof ServerWorld) {
                this.fakePlayer = this.setupBeforeTrigger((ServerWorld)this.field_145850_b, "forester");
            }
            this.equipTool();
            ItemStack dropMe = this.inventory.getStackInSlot(0).func_77946_l();
            if (this.isTree(targetPos)) {
                if (TileEntityBase.tryHarvestBlock(this.fakePlayer, this.field_145850_b, targetPos)) {
                    this.energy.extractEnergy(cost, false);
                }
            } else if (this.isSapling(dropMe) && targetPos.func_177956_o() == this.field_174879_c.func_177956_o() && (result = TileEntityBase.rightClickBlock(this.fakePlayer, this.field_145850_b, targetPos, Hand.OFF_HAND, Direction.DOWN)) == ActionResultType.CONSUME) {
                this.energy.extractEnergy(cost, false);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Forester action item error", e);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerForester(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        this.radius = tag.func_74762_e("radius");
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_74768_a("radius", this.radius);
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    private void equipTool() {
        if (this.fakePlayer == null) {
            return;
        }
        TileEntityBase.tryEquipItem(this.inventoryCap, this.fakePlayer, 0, Hand.OFF_HAND);
        if (((FakePlayer)this.fakePlayer.get()).func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            ItemStack tool = new ItemStack((IItemProvider)Items.field_151056_x);
            tool.func_77966_a(Enchantments.field_185308_t, 3);
            TileEntityBase.tryEquipItem(tool, this.fakePlayer, Hand.MAIN_HAND);
        }
    }

    private void skipSomeAirBlocks(List<BlockPos> shape) {
    }

    private BlockPos getShapeTarget(List<BlockPos> shape) {
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        return shape.get(this.shapeIndex);
    }

    public List<BlockPos> getShape() {
        ArrayList<BlockPos> shape = new ArrayList();
        shape = UtilShape.cubeSquareBase(this.getCurrentFacingPos(this.radius + 1), this.radius, this.height);
        return shape;
    }

    public List<BlockPos> getShapeHollow() {
        List<BlockPos> shape = UtilShape.squareHorizontalHollow(this.getCurrentFacingPos(this.radius + 1), this.radius);
        BlockPos targetPos = this.getShapeTarget(shape);
        if (targetPos != null) {
            shape.add(targetPos);
        }
        return shape;
    }

    private boolean isSapling(ItemStack dropMe) {
        Block block = Block.func_149634_a((Item)dropMe.func_77973_b());
        return block.func_203417_a((ITag)BlockTags.field_200030_g) || block instanceof SaplingBlock;
    }

    private boolean isTree(BlockPos targetPos) {
        if (targetPos == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(targetPos).func_177230_c();
        return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case SIZE: {
                return this.radius;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case SIZE: {
                this.radius = value % 12;
            }
        }
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE;

    }
}

