/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.energy;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.TileCableBase;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.net.PacketEnergySync;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileCableEnergy
extends TileCableBase
implements ITickableTileEntity {
    private static final int MAX = 32000;
    final CustomEnergyStorage energy = new CustomEnergyStorage(32000, 32000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final ConcurrentHashMap<Direction, LazyOptional<IEnergyStorage>> energyCapSides = new ConcurrentHashMap();
    private final Map<Direction, Integer> mapIncomingEnergy = Maps.newHashMap();
    private int energyLastSynced = -1;
    private static final int TIMER_SIDE_INPUT = 15;

    public TileCableEnergy() {
        super(TileRegistry.energy_pipeTile);
        for (Direction f : Direction.values()) {
            this.mapIncomingEnergy.put(f, 0);
        }
    }

    @Override
    public void updateConnection(Direction side, EnumConnectType connectType) {
        EnumConnectType oldConnectType = this.getConnectionType(side);
        if (connectType == EnumConnectType.BLOCKED && oldConnectType != EnumConnectType.BLOCKED) {
            LazyOptional<IEnergyStorage> sidedCap = this.energyCapSides.get(side);
            if (sidedCap != null) {
                sidedCap.invalidate();
                this.energyCapSides.remove(side);
            }
        } else if (oldConnectType == EnumConnectType.BLOCKED && connectType != EnumConnectType.BLOCKED) {
            this.energyCapSides.put(side, (LazyOptional<IEnergyStorage>)LazyOptional.of(() -> this.energy));
        }
        super.updateConnection(side, connectType);
    }

    public void func_73660_a() {
        this.syncEnergy();
        this.tickDownIncomingPowerFaces();
        this.tickCableFlow();
        for (Direction extractSide : Direction.values()) {
            EnumConnectType connection = this.getConnectionType(extractSide);
            if (!connection.isExtraction()) continue;
            this.tryExtract(extractSide);
        }
    }

    private void tryExtract(Direction extractSide) {
        if (extractSide == null) {
            return;
        }
        BlockPos posTarget = this.field_174879_c.func_177972_a(extractSide);
        TileEntity tile = this.field_145850_b.func_175625_s(posTarget);
        if (tile == null) {
            return;
        }
        IEnergyStorage itemHandlerFrom = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, extractSide.func_176734_d()).orElse(null);
        if (itemHandlerFrom == null) {
            return;
        }
        int capacity = this.energy.getMaxEnergyStored() - this.energy.getEnergyStored();
        if (capacity <= 0) {
            return;
        }
        int energyToExtract = itemHandlerFrom.extractEnergy(capacity, true);
        if (energyToExtract <= 0) {
            return;
        }
        int energyReceived = this.energy.receiveEnergy(energyToExtract, false);
        if (energyReceived <= 0) {
            return;
        }
        int energyExtracted = itemHandlerFrom.extractEnergy(energyReceived, false);
        if (energyExtracted != energyReceived) {
            ModCyclic.LOGGER.error("Imbalance extracting energy, extracted " + energyExtracted + " received " + energyReceived);
        }
    }

    private void tickCableFlow() {
        for (Direction outgoingSide : UtilDirection.getAllInDifferentOrder()) {
            EnumConnectType connection = this.getConnectionType(outgoingSide);
            if (connection.isExtraction() || connection.isBlocked() || this.isEnergyIncomingFromFace(outgoingSide)) continue;
            this.moveEnergy(outgoingSide, 32000);
        }
    }

    public void tickDownIncomingPowerFaces() {
        for (Direction incomingDirection : Direction.values()) {
            this.mapIncomingEnergy.computeIfPresent(incomingDirection, (direction, amount) -> {
                if (amount > 0) {
                    amount = amount - 1;
                }
                return amount;
            });
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            if (side == null) {
                return this.energyCap.cast();
            }
            LazyOptional sidedCap = this.energyCapSides.get(side);
            if (sidedCap == null) {
                if (this.getConnectionType(side) != EnumConnectType.BLOCKED) {
                    sidedCap = LazyOptional.of(() -> this.energy);
                    this.energyCapSides.put(side, (LazyOptional<IEnergyStorage>)sidedCap);
                    return sidedCap.cast();
                }
            } else {
                return sidedCap.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        for (LazyOptional<IEnergyStorage> sidedCap : this.energyCapSides.values()) {
            sidedCap.invalidate();
        }
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            this.mapIncomingEnergy.put(f, tag.func_74762_e(f.func_176610_l() + "_incenergy"));
        }
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            tag.func_74768_a(f.func_176610_l() + "_incenergy", this.mapIncomingEnergy.get(f).intValue());
        }
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        return super.func_189515_b(tag);
    }

    private boolean isEnergyIncomingFromFace(Direction face) {
        return this.mapIncomingEnergy.get(face) > 0;
    }

    public void updateIncomingEnergyFace(Direction inputFrom) {
        this.mapIncomingEnergy.put(inputFrom, 15);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    @Override
    protected void syncEnergy() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        int currentEnergy = this.energy.getEnergyStored();
        if (currentEnergy != this.energyLastSynced) {
            PacketEnergySync packetEnergySync = new PacketEnergySync(this.func_174877_v(), currentEnergy);
            PacketRegistry.sendToAllClients(this.field_145850_b, packetEnergySync);
            this.energyLastSynced = currentEnergy;
        }
    }
}

