/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.capability.CapabilityProviderEnergyStack;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBlockBattery
extends BlockItem {
    public static final String ENERGYTTMAX = "energyttmax";
    public static final String ENERGYTT = "energytt";

    public ItemBlockBattery(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(ENERGYTT);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xBC000C;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ENERGYTT)) {
            int current = stack.func_77978_p().func_74762_e(ENERGYTT);
            int energyttmax = stack.func_77978_p().func_74762_e(ENERGYTTMAX);
            tooltip.add((ITextComponent)new TranslationTextComponent(current + "/" + energyttmax).func_240699_a_(TextFormatting.RED));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double current = 0.0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ENERGYTT)) {
            current = stack.func_77978_p().func_74762_e(ENERGYTT);
        }
        double max = Math.max(1.0, (double)stack.func_77978_p().func_74762_e(ENERGYTTMAX));
        return 1.0 - current / max;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new CapabilityProviderEnergyStack(6400000);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (storage != null) {
            nbt.func_74768_a(ENERGYTT, storage.getEnergyStored());
            nbt.func_74768_a(ENERGYTTMAX, storage.getMaxEnergyStored());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbt) {
        if (nbt != null) {
            CompoundNBT stackTag = stack.func_196082_o();
            stackTag.func_74768_a(ENERGYTT, nbt.func_74762_e(ENERGYTT));
            stackTag.func_74768_a(ENERGYTTMAX, nbt.func_74762_e(ENERGYTTMAX));
        }
        super.readShareTag(stack, nbt);
    }
}

