/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.util.TriConsumer;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class CuriosHelper
implements ICuriosHelper {
    private static final Map<String, SlotAttributeWrapper> SLOT_ATTRIBUTES = new HashMap<String, SlotAttributeWrapper>();
    private static TriConsumer<String, Integer, LivingEntity> brokenCurioConsumer;

    @Override
    public LazyOptional<ICurio> getCurio(ItemStack stack) {
        return stack.getCapability(CuriosCapability.ITEM);
    }

    @Override
    public LazyOptional<ICuriosItemHandler> getCuriosHandler(@Nonnull LivingEntity livingEntity) {
        return livingEntity.getCapability(CuriosCapability.INVENTORY);
    }

    @Override
    public Set<String> getCurioTags(Item item) {
        return item.getTags().stream().filter(tag -> tag.func_110624_b().equals("curios")).map(ResourceLocation::func_110623_a).collect(Collectors.toSet());
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getEquippedCurios(LivingEntity livingEntity) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).lazyMap(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            IItemHandlerModifiable[] itemHandlers = new IItemHandlerModifiable[curios.size()];
            int index = 0;
            for (ICurioStacksHandler stacksHandler : curios.values()) {
                if (index >= itemHandlers.length) continue;
                itemHandlers[index] = stacksHandler.getStacks();
                ++index;
            }
            return new CombinedInvWrapper(itemHandlers);
        });
    }

    @Override
    public void setEquippedCurio(@Nonnull LivingEntity livingEntity, String identifier, int index, ItemStack stack) {
        this.getCuriosHandler(livingEntity).ifPresent(handler -> {
            IDynamicStackHandler stackHandler;
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            ICurioStacksHandler stacksHandler = curios.get(identifier);
            if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots()) {
                stackHandler.setStackInSlot(index, stack);
            }
        });
    }

    @Override
    public Optional<SlotResult> findFirstCurio(@Nonnull LivingEntity livingEntity, Item item) {
        return this.findFirstCurio(livingEntity, (ItemStack stack) -> stack.func_77973_b() == item);
    }

    @Override
    public Optional<SlotResult> findFirstCurio(@Nonnull LivingEntity livingEntity, Predicate<ItemStack> filter) {
        SlotResult result = this.getCuriosHandler(livingEntity).map(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new SlotResult(new SlotContext(id, livingEntity, i), stack);
                }
            }
            return new SlotResult(null, ItemStack.field_190927_a);
        }).orElse(new SlotResult(null, ItemStack.field_190927_a));
        return result.getStack().func_190926_b() ? Optional.empty() : Optional.of(result);
    }

    @Override
    public List<SlotResult> findCurios(@Nonnull LivingEntity livingEntity, Item item) {
        return this.findCurios(livingEntity, (ItemStack stack) -> stack.func_77973_b() == item);
    }

    @Override
    public List<SlotResult> findCurios(@Nonnull LivingEntity livingEntity, Predicate<ItemStack> filter) {
        ArrayList<SlotResult> result = new ArrayList<SlotResult>();
        this.getCuriosHandler(livingEntity).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    result.add(new SlotResult(new SlotContext(id, livingEntity, i), stack));
                }
            }
        });
        return result;
    }

    @Override
    public List<SlotResult> findCurios(@Nonnull LivingEntity livingEntity, String ... identifiers) {
        ArrayList<SlotResult> result = new ArrayList<SlotResult>();
        Set ids = Arrays.stream(identifiers).collect(Collectors.toSet());
        this.getCuriosHandler(livingEntity).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                if (!ids.contains(id)) continue;
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    result.add(new SlotResult(new SlotContext(id, livingEntity, i), stack));
                }
            }
        });
        return result;
    }

    @Override
    public Optional<SlotResult> findCurio(@Nonnull LivingEntity livingEntity, String identifier, int index) {
        SlotResult result = this.getCuriosHandler(livingEntity).map(handler -> {
            ItemStack stack;
            IDynamicStackHandler stackHandler;
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            ICurioStacksHandler stacksHandler = curios.get(identifier);
            if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots() && !(stack = stackHandler.getStackInSlot(index)).func_190926_b()) {
                return new SlotResult(new SlotContext(identifier, livingEntity, index), stack);
            }
            return new SlotResult(null, ItemStack.field_190927_a);
        }).orElse(new SlotResult(null, ItemStack.field_190927_a));
        return result.getStack().func_190926_b() ? Optional.empty() : Optional.of(result);
    }

    @Override
    @Nonnull
    public Optional<ImmutableTriple<String, Integer, ItemStack>> findEquippedCurio(Item item, @Nonnull LivingEntity livingEntity) {
        return this.findEquippedCurio((ItemStack stack) -> stack.func_77973_b() == item, livingEntity);
    }

    @Override
    @Nonnull
    public Optional<ImmutableTriple<String, Integer, ItemStack>> findEquippedCurio(Predicate<ItemStack> filter, @Nonnull LivingEntity livingEntity) {
        ImmutableTriple result = this.getCuriosHandler(livingEntity).map(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier, ItemStack stack) {
        return this.getAttributeModifiers(new SlotContext(identifier), UUID.randomUUID(), stack);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("CurioAttributeModifiers", 9)) {
            HashMultimap multimap = HashMultimap.create();
            ListNBT listnbt = stack.func_77978_p().func_150295_c("CurioAttributeModifiers", 10);
            String identifier = slotContext.getIdentifier();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                if (!compoundnbt.func_74779_i("Slot").equals(identifier)) continue;
                ResourceLocation rl = ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("AttributeName"));
                UUID id = uuid;
                if (rl == null) continue;
                if (compoundnbt.func_74764_b("UUID")) {
                    id = compoundnbt.func_186857_a("UUID");
                }
                if (id.getLeastSignificantBits() == 0L || id.getMostSignificantBits() == 0L) continue;
                AttributeModifier.Operation operation = AttributeModifier.Operation.func_220372_a((int)compoundnbt.func_74762_e("Operation"));
                double amount = compoundnbt.func_74769_h("Amount");
                String name = compoundnbt.func_74779_i("Name");
                if (rl.func_110624_b().equals("curios")) {
                    String identifier1 = rl.func_110623_a();
                    if (!CuriosApi.getSlotHelper().getSlotType(identifier1).isPresent()) continue;
                    CuriosApi.getCuriosHelper().addSlotModifier((Multimap<Attribute, AttributeModifier>)multimap, identifier1, id, amount, operation);
                    continue;
                }
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(rl);
                if (attribute == null) continue;
                multimap.put((Object)attribute, (Object)new AttributeModifier(id, name, amount, operation));
            }
            return multimap;
        }
        return (Multimap)this.getCurio(stack).map(curio -> curio.getAttributeModifiers(slotContext, uuid)).orElse(HashMultimap.create());
    }

    @Override
    public void addSlotModifier(Multimap<Attribute, AttributeModifier> map, String identifier, UUID uuid, double amount, AttributeModifier.Operation operation) {
        map.put((Object)CuriosHelper.getOrCreateSlotAttribute(identifier), (Object)new AttributeModifier(uuid, identifier, amount, operation));
    }

    @Override
    public void addSlotModifier(ItemStack stack, String identifier, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        this.addModifier(stack, CuriosHelper.getOrCreateSlotAttribute(identifier), name, uuid, amount, operation, slot);
    }

    @Override
    public void addModifier(ItemStack stack, Attribute attribute, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_150297_b("CurioAttributeModifiers", 9)) {
            tag.func_218657_a("CurioAttributeModifiers", (INBT)new ListNBT());
        }
        ListNBT listtag = tag.func_150295_c("CurioAttributeModifiers", 10);
        CompoundNBT compoundtag = new CompoundNBT();
        compoundtag.func_74778_a("Name", name);
        compoundtag.func_74780_a("Amount", amount);
        compoundtag.func_74768_a("Operation", operation.func_220371_a());
        if (uuid != null) {
            compoundtag.func_186854_a("UUID", uuid);
        }
        String id = "";
        if (attribute instanceof SlotAttributeWrapper) {
            SlotAttributeWrapper wrapper = (SlotAttributeWrapper)attribute;
            id = "curios:" + wrapper.identifier;
        } else {
            ResourceLocation rl = ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attribute);
            if (rl != null) {
                id = rl.toString();
            }
        }
        if (!id.isEmpty()) {
            compoundtag.func_74778_a("AttributeName", id);
        }
        compoundtag.func_74778_a("Slot", slot);
        listtag.add((Object)compoundtag);
    }

    @Override
    public boolean isStackValid(SlotContext slotContext, ItemStack stack) {
        String id = slotContext.getIdentifier();
        Set<String> tags = this.getCurioTags(stack.func_77973_b());
        return !tags.isEmpty() && id.equals(SlotTypePreset.CURIO.getIdentifier()) || tags.contains(id) || tags.contains(SlotTypePreset.CURIO.getIdentifier());
    }

    @Override
    public void onBrokenCurio(String id, int index, LivingEntity damager) {
        brokenCurioConsumer.accept((Object)id, (Object)index, (Object)damager);
    }

    @Override
    public void setBrokenCurioConsumer(TriConsumer<String, Integer, LivingEntity> consumer) {
        if (brokenCurioConsumer == null) {
            brokenCurioConsumer = consumer;
        }
    }

    public static SlotAttributeWrapper getOrCreateSlotAttribute(String identifier) {
        return SLOT_ATTRIBUTES.computeIfAbsent(identifier, x$0 -> new SlotAttributeWrapper((String)x$0));
    }

    public static class SlotAttributeWrapper
    extends Attribute {
        public final String identifier;

        private SlotAttributeWrapper(String identifier) {
            super("curios.slot." + identifier, 0.0);
            this.identifier = identifier;
        }
    }
}

