/*
 * Decompiled with CFR 0.152.
 */
package thepoultryman.crops_love_rain;

import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5819;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thepoultryman.crops_love_rain.config.CropsConfigManager;

public class CropsLoveRain
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"crops_love_rain");
    public static final CropsConfigManager CONFIG = new CropsConfigManager("crops-love-rain", true);

    public void onInitialize() {
        CONFIG.loadConfig();
    }

    public static boolean shouldGrowExtra(class_1937 world, class_2338 blockPos, class_5819 random, CropType cropType) {
        if (!world.method_8520(blockPos) || !CropsLoveRain.CONFIG.useRainGrowthSpeed) {
            return false;
        }
        int growthSpeed = 0;
        if (CropsLoveRain.CONFIG.useIndividualSpeeds) {
            if (CONFIG.usesCustomSpeed(cropType)) {
                growthSpeed = switch (cropType) {
                    default -> throw new IncompatibleClassChangeError();
                    case CropType.Bamboo -> CropsLoveRain.CONFIG.bambooCustomSpeed;
                    case CropType.Crop -> CropsLoveRain.CONFIG.cropsCustomSpeed;
                    case CropType.Sapling -> CropsLoveRain.CONFIG.saplingCustomSpeed;
                    case CropType.SugarCane -> CropsLoveRain.CONFIG.sugarCaneCustomSpeed;
                };
                return random.method_43048(growthSpeed) == 0;
            }
            return random.method_43048(CropsLoveRain.CONFIG.rainGrowthSpeed) == 0;
        }
        return random.method_43048(CropsLoveRain.CONFIG.rainGrowthSpeed) == 0;
    }

    public static enum CropType {
        Bamboo,
        Crop,
        Sapling,
        SugarCane;

    }
}

