/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.alternator;

import com.mrh0.createaddition.blocks.alternator.AlternatorBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.item.Multimeter;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class AlternatorTileEntity
extends KineticTileEntity {
    protected final InternalEnergyStorage energy;
    private LazyOptional<IEnergyStorage> lazyEnergy;
    private static final int MAX_IN = 0;
    private static final int MAX_OUT = (Integer)Config.ALTERNATOR_MAX_OUTPUT.get();
    private static final int CAPACITY = (Integer)Config.ALTERNATOR_CAPACITY.get();
    private static final int STRESS = (Integer)Config.BASELINE_STRESS.get();
    private static final double EFFICIENCY = (Double)Config.ALTERNATOR_EFFICIENCY.get();
    private boolean firstTickState = true;
    private LazyOptional<IEnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheWest = LazyOptional.empty();

    public AlternatorTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.energy = new InternalEnergyStorage(CAPACITY, 0, MAX_OUT);
        this.lazyEnergy = LazyOptional.of(() -> this.energy);
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.energy.production").func_240699_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new StringTextComponent(" " + Multimeter.format(AlternatorTileEntity.getEnergyProductionRate((int)(this.isSpeedRequirementFulfilled() ? this.getSpeed() : 0.0f))) + "fe/t ").func_240699_a_(TextFormatting.AQUA)).func_230529_a_((ITextComponent)Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).func_240699_a_(TextFormatting.DARK_GRAY)));
        added = true;
        return added;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)STRESS / 256.0f;
        return impact;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (this.isEnergyInput(side) || this.isEnergyOutput(side))) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isEnergyInput(Direction side) {
        return false;
    }

    public boolean isEnergyOutput(Direction side) {
        return side != this.func_195044_w().func_177229_b((Property)AlternatorBlock.FACING);
    }

    public void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.energy.read(compound);
    }

    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            this.energy.internalProduceEnergy(AlternatorTileEntity.getEnergyProductionRate((int)this.getSpeed()));
        }
        for (Direction d : Direction.values()) {
            IEnergyStorage ies;
            if (!this.isEnergyOutput(d) || (ies = this.getCachedEnergy(d)) == null) continue;
            int ext = this.energy.extractEnergy(ies.receiveEnergy(MAX_OUT, true), false);
            int n = ies.receiveEnergy(ext, false);
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)((Integer)Config.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0) * EFFICIENCY);
    }

    protected Block getStressConfigKey() {
        return (Block)AllBlocks.MECHANICAL_MIXER.get();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.lazyEnergy.invalidate();
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        for (Direction side : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (te == null) {
                this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
                continue;
            }
            LazyOptional le = te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
            this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        }
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        switch (side) {
            case DOWN: {
                this.escacheDown = storage;
                break;
            }
            case EAST: {
                this.escacheEast = storage;
                break;
            }
            case NORTH: {
                this.escacheNorth = storage;
                break;
            }
            case SOUTH: {
                this.escacheSouth = storage;
                break;
            }
            case UP: {
                this.escacheUp = storage;
                break;
            }
            case WEST: {
                this.escacheWest = storage;
            }
        }
    }

    public IEnergyStorage getCachedEnergy(Direction side) {
        switch (side) {
            case DOWN: {
                return (IEnergyStorage)this.escacheDown.orElse(null);
            }
            case EAST: {
                return (IEnergyStorage)this.escacheEast.orElse(null);
            }
            case NORTH: {
                return (IEnergyStorage)this.escacheNorth.orElse(null);
            }
            case SOUTH: {
                return (IEnergyStorage)this.escacheSouth.orElse(null);
            }
            case UP: {
                return (IEnergyStorage)this.escacheUp.orElse(null);
            }
            case WEST: {
                return (IEnergyStorage)this.escacheWest.orElse(null);
            }
        }
        return null;
    }

    public World getWorld() {
        return this.func_145831_w();
    }
}

