/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class CameraAngleAnimationService {
    private static final LerpedFloat yRotation = LerpedFloat.angular().startWithValue(0.0);
    private static final LerpedFloat xRotation = LerpedFloat.angular().startWithValue(0.0);
    private static Mode animationMode = Mode.LINEAR;
    private static float animationSpeed = -1.0f;

    public static void tick() {
        yRotation.tickChaser();
        xRotation.tickChaser();
        if (class_310.method_1551().field_1724 != null) {
            if (!yRotation.settled()) {
                class_310.method_1551().field_1724.method_36456(yRotation.getValue(1.0f));
            }
            if (!xRotation.settled()) {
                class_310.method_1551().field_1724.method_36457(xRotation.getValue(1.0f));
            }
        }
    }

    public static boolean isYawAnimating() {
        return !yRotation.settled();
    }

    public static boolean isPitchAnimating() {
        return !xRotation.settled();
    }

    public static float getYaw(float partialTicks) {
        return yRotation.getValue(partialTicks);
    }

    public static float getPitch(float partialTicks) {
        return xRotation.getValue(partialTicks);
    }

    public static void setAnimationMode(Mode mode) {
        animationMode = mode;
    }

    public static void setAnimationSpeed(float speed) {
        animationSpeed = speed;
    }

    public static void setYawTarget(float yaw) {
        float currentYaw = CameraAngleAnimationService.getCurrentYaw();
        yRotation.startWithValue(currentYaw);
        CameraAngleAnimationService.setupChaser(yRotation, currentYaw + AngleHelper.getShortestAngleDiff(currentYaw, class_3532.method_15393((float)yaw)));
    }

    public static void setPitchTarget(float pitch) {
        float currentPitch = CameraAngleAnimationService.getCurrentPitch();
        xRotation.startWithValue(currentPitch);
        CameraAngleAnimationService.setupChaser(xRotation, currentPitch + AngleHelper.getShortestAngleDiff(currentPitch, class_3532.method_15393((float)pitch)));
    }

    private static float getCurrentYaw() {
        if (class_310.method_1551().field_1724 == null) {
            return 0.0f;
        }
        return class_3532.method_15393((float)class_310.method_1551().field_1724.method_36454());
    }

    private static float getCurrentPitch() {
        if (class_310.method_1551().field_1724 == null) {
            return 0.0f;
        }
        return class_3532.method_15393((float)class_310.method_1551().field_1724.method_36455());
    }

    private static void setupChaser(LerpedFloat rotation, float target) {
        if (animationMode == Mode.LINEAR) {
            rotation.chase(target, animationSpeed > 0.0f ? (double)animationSpeed : 2.0, LerpedFloat.Chaser.LINEAR);
        } else if (animationMode == Mode.EXPONENTIAL) {
            rotation.chase(target, animationSpeed > 0.0f ? (double)animationSpeed : 0.25, LerpedFloat.Chaser.EXP);
        }
    }

    public static enum Mode {
        LINEAR,
        EXPONENTIAL;

    }
}

