/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.simibubi.create.Create;
import io.github.fabricators_of_create.porting_lib.models.CompositeModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

public class MultiRenderTypeModel
extends ForwardingBakedModel {
    protected static final RenderMaterial SOLID_MATERIAL;
    protected static final RenderMaterial CUTOUT_MATERIAL;
    protected static final RenderMaterial TRANSLUCENT_MATERIAL;
    protected final Map<String, RenderMaterial> parts;

    protected MultiRenderTypeModel(CompositeModel.Baked wrapped, Map<String, RenderMaterial> parts) {
        this.wrapped = wrapped;
        this.parts = parts;
        parts.keySet().forEach(name -> {
            class_1087 part = wrapped.getPart(name);
            if (part == null) {
                throw new IllegalArgumentException("Expected part " + name + " is not present");
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class_1087 forNixieTube(class_1087 wrapped) {
        return MultiRenderTypeModel.builder().solid("connectors").translucent("tubes").build(wrapped);
    }

    public static class_1087 forDisplayLink(class_1087 wrapped) {
        return MultiRenderTypeModel.builder().solid("base").cutout("bulb_inner").translucent("bulb").build(wrapped);
    }

    protected FabricBakedModel getPart(String name) {
        return ((CompositeModel.Baked)this.wrapped).getPart(name);
    }

    protected static boolean setMaterial(MutableQuadView quad, RenderMaterial material) {
        quad.material(material);
        return true;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.parts.forEach((name, material) -> {
            context.pushTransform(quad -> MultiRenderTypeModel.setMaterial(quad, material));
            this.getPart((String)name).emitBlockQuads(blockView, state, pos, randomSupplier, context);
            context.popTransform();
        });
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.parts.forEach((name, material) -> {
            context.pushTransform(quad -> MultiRenderTypeModel.setMaterial(quad, material));
            this.getPart((String)name).emitItemQuads(stack, randomSupplier, context);
            context.popTransform();
        });
    }

    public static boolean isInvalid() {
        return SOLID_MATERIAL == null || TRANSLUCENT_MATERIAL == null || CUTOUT_MATERIAL == null;
    }

    static {
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        if (renderer == null) {
            Create.LOGGER.error("No renderer present, rendering will be wrong. If you have Sodium, install Indium!");
            TRANSLUCENT_MATERIAL = null;
            CUTOUT_MATERIAL = null;
            SOLID_MATERIAL = null;
        } else {
            MaterialFinder finder = renderer.materialFinder();
            SOLID_MATERIAL = finder.blendMode(0, BlendMode.SOLID).find();
            CUTOUT_MATERIAL = finder.blendMode(0, BlendMode.CUTOUT).find();
            TRANSLUCENT_MATERIAL = finder.blendMode(0, BlendMode.TRANSLUCENT).find();
        }
    }

    public static class Builder {
        private final Set<String> solidParts = new HashSet<String>();
        private final Set<String> translucentParts = new HashSet<String>();
        private final Set<String> cutoutParts = new HashSet<String>();

        public Builder solid(String ... solid) {
            Collections.addAll(this.solidParts, solid);
            return this;
        }

        public Builder translucent(String ... translucent) {
            Collections.addAll(this.translucentParts, translucent);
            return this;
        }

        public Builder cutout(String ... cutout) {
            Collections.addAll(this.cutoutParts, cutout);
            return this;
        }

        public class_1087 build(class_1087 wrapped) {
            if (!(wrapped instanceof CompositeModel.Baked)) {
                throw new IllegalArgumentException("Cannot create a MultiRenderTypeModel for a wrapped model that isn't CompositeModel.Baked");
            }
            CompositeModel.Baked baked = (CompositeModel.Baked)wrapped;
            if (MultiRenderTypeModel.isInvalid()) {
                return wrapped;
            }
            HashMap<String, RenderMaterial> parts = new HashMap<String, RenderMaterial>();
            this.solidParts.forEach(part -> parts.put((String)part, SOLID_MATERIAL));
            this.translucentParts.forEach(part -> parts.put((String)part, TRANSLUCENT_MATERIAL));
            this.cutoutParts.forEach(part -> parts.put((String)part, CUTOUT_MATERIAL));
            return new MultiRenderTypeModel(baked, parts);
        }
    }
}

