/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class FluidHelper {
    public static boolean isWater(class_3611 fluid) {
        return FluidHelper.convertToStill(fluid) == class_3612.field_15910;
    }

    public static boolean isLava(class_3611 fluid) {
        return FluidHelper.convertToStill(fluid) == class_3612.field_15908;
    }

    public static boolean isTag(class_3611 fluid, class_6862<class_3611> tag) {
        return fluid.method_15791(tag);
    }

    public static boolean isTag(class_3610 fluid, class_6862<class_3611> tag) {
        return fluid.method_15767(tag);
    }

    public static boolean isTag(FluidStack fluid, class_6862<class_3611> tag) {
        return FluidHelper.isTag(fluid.getFluid(), tag);
    }

    public static class_3414 getFillSound(FluidStack fluid) {
        return FluidVariantAttributes.getFillSound((FluidVariant)fluid.getType());
    }

    public static class_3414 getEmptySound(FluidStack fluid) {
        return FluidVariantAttributes.getEmptySound((FluidVariant)fluid.getType());
    }

    public static boolean hasBlockState(class_3611 fluid) {
        return !fluid.method_15785().method_15759().method_26215();
    }

    public static FluidStack copyStackWithAmount(FluidStack fs, long amount) {
        if (amount <= 0L) {
            return FluidStack.EMPTY;
        }
        if (fs.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack copy = fs.copy();
        copy.setAmount(amount);
        return copy;
    }

    public static class_3611 convertToFlowing(class_3611 fluid) {
        if (fluid == class_3612.field_15910) {
            return class_3612.field_15909;
        }
        if (fluid == class_3612.field_15908) {
            return class_3612.field_15907;
        }
        if (fluid instanceof class_3609) {
            return ((class_3609)fluid).method_15750();
        }
        return fluid;
    }

    public static class_3611 convertToStill(class_3611 fluid) {
        if (fluid == class_3612.field_15909) {
            return class_3612.field_15910;
        }
        if (fluid == class_3612.field_15907) {
            return class_3612.field_15908;
        }
        if (fluid instanceof class_3609) {
            return ((class_3609)fluid).method_15751();
        }
        return fluid;
    }

    public static JsonElement serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", RegisteredObjects.getKeyOrThrow(stack.getFluid()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        class_2960 id = new class_2960(class_3518.method_15265((JsonObject)json, (String)"fluid"));
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(id);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + id + "'");
        }
        int amount = class_3518.method_15260((JsonObject)json, (String)"amount");
        if (!json.has("nbt")) {
            return new FluidStack(fluid, (long)amount);
        }
        try {
            JsonElement element = json.get("nbt");
            class_2487 nbt = class_2522.method_10718((String)(element.isJsonObject() ? Create.GSON.toJson(element) : class_3518.method_15287((JsonElement)element, (String)"nbt")));
            return new FluidStack(FluidVariant.of((class_3611)fluid, (class_2487)nbt), (long)amount, nbt);
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Failed to read NBT", (Throwable)e);
        }
    }

    public static boolean tryEmptyItemIntoBE(class_1937 worldIn, class_1657 player, class_1268 handIn, class_1799 heldItem, SmartBlockEntity be, class_2350 side) {
        if (!GenericItemEmptying.canItemBeEmptied(worldIn, heldItem)) {
            return false;
        }
        Pair<FluidStack, class_1799> emptyingResult = GenericItemEmptying.emptyItem(worldIn, heldItem, true);
        Storage tank = (Storage)FluidStorage.SIDED.find(worldIn, be.method_11016(), null, (class_2586)be, (Object)side);
        FluidStack fluidStack = emptyingResult.getFirst();
        if (tank == null) {
            return false;
        }
        if (worldIn.field_9236) {
            return true;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            long inserted = tank.insert((Object)fluidStack.getType(), fluidStack.getAmount(), (TransactionContext)t);
            if (inserted != fluidStack.getAmount()) {
                boolean bl = false;
                return bl;
            }
            class_1799 copyOfHeld = heldItem.method_7972();
            emptyingResult = GenericItemEmptying.emptyItem(worldIn, copyOfHeld, false);
            t.commit();
            if (!player.method_7337() && !(be instanceof CreativeFluidTankBlockEntity)) {
                if (copyOfHeld.method_7960()) {
                    player.method_6122(handIn, emptyingResult.getSecond());
                } else {
                    player.method_6122(handIn, copyOfHeld);
                    player.method_31548().method_7398(emptyingResult.getSecond());
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    public static boolean tryFillItemFromBE(class_1937 world, class_1657 player, class_1268 handIn, class_1799 heldItem, SmartBlockEntity be, class_2350 side) {
        if (!GenericItemFilling.canItemBeFilled(world, heldItem)) {
            return false;
        }
        Storage tank = (Storage)FluidStorage.SIDED.find(world, be.method_11016(), null, (class_2586)be, (Object)side);
        if (tank == null) {
            return false;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            for (FluidStack fluid : TransferUtil.getAllFluids((Storage)tank)) {
                long requiredAmountForItem;
                if (fluid.isEmpty() || (requiredAmountForItem = GenericItemFilling.getRequiredAmountForItem(world, heldItem, fluid.copy())) == -1L || requiredAmountForItem > fluid.getAmount()) continue;
                if (world.field_9236) {
                    boolean bl = true;
                    return bl;
                }
                if (player.method_7337() || be instanceof CreativeFluidTankBlockEntity) {
                    heldItem = heldItem.method_7972();
                }
                class_1799 out = GenericItemFilling.fillItem(world, requiredAmountForItem, heldItem, fluid.copy());
                FluidStack copy = fluid.copy();
                copy.setAmount(requiredAmountForItem);
                tank.extract((Object)copy.getType(), copy.getAmount(), (TransactionContext)t);
                t.commit();
                if (!player.method_7337()) {
                    player.method_31548().method_7398(out);
                }
                be.notifyUpdate();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static enum FluidExchange {
        ITEM_TO_TANK,
        TANK_TO_ITEM;

    }
}

