/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.simibubi.create.foundation.utility.Iterate;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class CombinedTankWrapper
extends CombinedStorage<FluidVariant, Storage<FluidVariant>> {
    protected boolean enforceVariety;

    public CombinedTankWrapper(Storage<FluidVariant> ... fluidHandlers) {
        super(List.of(fluidHandlers));
    }

    public CombinedTankWrapper enforceVariety() {
        this.enforceVariety = true;
        return this;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (resource.isBlank()) {
            return 0L;
        }
        int filled = 0;
        boolean fittingHandlerFound = false;
        block5: for (boolean searchPass : Iterate.trueAndFalse) {
            for (Storage iFluidHandler : this.parts) {
                try (Transaction nested = transaction.openNested();){
                    if (searchPass && iFluidHandler.extract((Object)resource, 1L, (TransactionContext)nested) == 1L) {
                        fittingHandlerFound = true;
                    }
                }
                if (searchPass && !fittingHandlerFound) continue;
                long filledIntoCurrent = iFluidHandler.insert((Object)resource, maxAmount, transaction);
                filled = (int)((long)filled + filledIntoCurrent);
                if ((maxAmount -= filledIntoCurrent) != 0L && (!fittingHandlerFound || !this.enforceVariety && filledIntoCurrent == 0L)) continue;
                break block5;
            }
        }
        return filled;
    }
}

