/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.SchematicExport;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.table.SchematicTableBlockEntity;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CSchematics;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class ServerSchematicLoader {
    private Map<String, SchematicUploadEntry> activeUploads = new HashMap<String, SchematicUploadEntry>();

    public String getSchematicPath() {
        return "schematics/uploaded";
    }

    public void tick() {
        HashSet<String> deadEntries = new HashSet<String>();
        for (String upload : this.activeUploads.keySet()) {
            SchematicUploadEntry entry = this.activeUploads.get(upload);
            if (entry.idleTime++ <= (Integer)this.getConfig().schematicIdleTimeout.get()) continue;
            Create.LOGGER.warn("Schematic Upload timed out: " + upload);
            deadEntries.add(upload);
        }
        deadEntries.forEach(this::cancelUpload);
    }

    public void shutdown() {
        new HashSet<String>(this.activeUploads.keySet()).forEach(this::cancelUpload);
    }

    public void handleNewUpload(class_3222 player, String schematic, long size, class_2338 pos) {
        String playerPath = this.getSchematicPath() + "/" + player.method_7334().getName();
        String playerSchematicId = player.method_7334().getName() + "/" + schematic;
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.LOGGER.warn("Attempted Schematic Upload with non-supported Format: " + playerSchematicId);
            return;
        }
        Path playerSchematicsPath = Paths.get(this.getSchematicPath(), player.method_7334().getName()).toAbsolutePath();
        Path uploadPath = playerSchematicsPath.resolve(schematic).normalize();
        if (!uploadPath.startsWith(playerSchematicsPath)) {
            Create.LOGGER.warn("Attempted Schematic Upload with directory escape: {}", (Object)playerSchematicId);
            return;
        }
        if (!this.validateSchematicSizeOnServer(player, size)) {
            return;
        }
        if (this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        try {
            long count;
            SchematicTableBlockEntity table = this.getTable(player.method_5770(), pos);
            if (table == null) {
                return;
            }
            Files.deleteIfExists(uploadPath);
            try (Stream<Path> list = Files.list(Paths.get(playerPath, new String[0]));){
                count = list.count();
            }
            if (count >= (long)((Integer)this.getConfig().maxSchematics.get()).intValue()) {
                Stream<Path> list2 = Files.list(Paths.get(playerPath, new String[0]));
                Optional<Path> lastFilePath = list2.filter(f -> !Files.isDirectory(f, new LinkOption[0])).min(Comparator.comparingLong(f -> f.toFile().lastModified()));
                list2.close();
                if (lastFilePath.isPresent()) {
                    Files.deleteIfExists(lastFilePath.get());
                }
            }
            OutputStream writer = Files.newOutputStream(uploadPath, new OpenOption[0]);
            this.activeUploads.put(playerSchematicId, new SchematicUploadEntry(writer, size, player.method_37908(), pos));
            table.startUpload(schematic);
        }
        catch (IOException e) {
            Create.LOGGER.error("Exception Thrown when starting Upload: " + playerSchematicId);
            e.printStackTrace();
        }
    }

    protected boolean validateSchematicSizeOnServer(class_3222 player, long size) {
        Integer maxFileSize = (Integer)this.getConfig().maxTotalSchematicSize.get();
        if (size > (long)(maxFileSize * 1000)) {
            player.method_43496((class_2561)Lang.translateDirect("schematics.uploadTooLarge", new Object[0]).method_10852((class_2561)Components.literal(" (" + size / 1000L + " KB).")));
            player.method_43496((class_2561)Lang.translateDirect("schematics.maxAllowedSize", new Object[0]).method_10852((class_2561)Components.literal(" " + maxFileSize + " KB")));
            return false;
        }
        return true;
    }

    public CSchematics getConfig() {
        return AllConfigs.server().schematics;
    }

    public void handleWriteRequest(class_3222 player, String schematic, byte[] data) {
        String playerSchematicId = player.method_7334().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            SchematicUploadEntry entry = this.activeUploads.get(playerSchematicId);
            entry.bytesUploaded += (long)data.length;
            if (data.length > (Integer)this.getConfig().maxSchematicPacketSize.get()) {
                Create.LOGGER.warn("Oversized Upload Packet received: " + playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            if (entry.bytesUploaded > entry.totalBytes) {
                Create.LOGGER.warn("Received more data than Expected: " + playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            try {
                entry.stream.write(data);
                entry.idleTime = 0;
                SchematicTableBlockEntity table = this.getTable(entry.world, entry.tablePos);
                if (table == null) {
                    return;
                }
                table.uploadingProgress = (float)((double)entry.bytesUploaded / (double)entry.totalBytes);
                table.sendUpdate = true;
            }
            catch (IOException e) {
                Create.LOGGER.error("Exception Thrown when uploading Schematic: " + playerSchematicId);
                e.printStackTrace();
                this.cancelUpload(playerSchematicId);
            }
        }
    }

    protected void cancelUpload(String playerSchematicId) {
        if (!this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        SchematicUploadEntry entry = this.activeUploads.remove(playerSchematicId);
        try {
            entry.stream.close();
            Files.deleteIfExists(Paths.get(this.getSchematicPath(), playerSchematicId));
            Create.LOGGER.warn("Cancelled Schematic Upload: " + playerSchematicId);
        }
        catch (IOException e) {
            Create.LOGGER.error("Exception Thrown when cancelling Upload: " + playerSchematicId);
            e.printStackTrace();
        }
        class_2338 pos = entry.tablePos;
        if (pos == null) {
            return;
        }
        SchematicTableBlockEntity table = this.getTable(entry.world, pos);
        if (table != null) {
            table.finishUpload();
        }
    }

    public SchematicTableBlockEntity getTable(class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof SchematicTableBlockEntity)) {
            return null;
        }
        SchematicTableBlockEntity table = (SchematicTableBlockEntity)be;
        return table;
    }

    public void handleFinishedUpload(class_3222 player, String schematic) {
        String playerSchematicId = player.method_7334().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            try {
                this.activeUploads.get((Object)playerSchematicId).stream.close();
                SchematicUploadEntry removed = this.activeUploads.remove(playerSchematicId);
                class_1937 world = removed.world;
                class_2338 pos = removed.tablePos;
                Create.LOGGER.info("New Schematic Uploaded: " + playerSchematicId);
                if (pos == null) {
                    return;
                }
                class_2680 blockState = world.method_8320(pos);
                if (AllBlocks.SCHEMATIC_TABLE.get() != blockState.method_26204()) {
                    return;
                }
                SchematicTableBlockEntity table = this.getTable(world, pos);
                if (table == null) {
                    return;
                }
                table.finishUpload();
                table.inventory.setStackInSlot(1, SchematicItem.create((class_7871<class_2248>)world.method_45448(class_7924.field_41254), schematic, player.method_7334().getName()));
            }
            catch (IOException e) {
                Create.LOGGER.error("Exception Thrown when finishing Upload: " + playerSchematicId);
                e.printStackTrace();
            }
        }
    }

    public void handleInstantSchematic(class_3222 player, String schematic, class_1937 world, class_2338 pos, class_2338 bounds) {
        String playerName = player.method_7334().getName();
        String playerPath = this.getSchematicPath() + "/" + playerName;
        String playerSchematicId = playerName + "/" + schematic;
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.LOGGER.warn("Attempted Schematic Upload with non-supported Format: {}", (Object)playerSchematicId);
            return;
        }
        Path schematicPath = Paths.get(this.getSchematicPath(), new String[0]).toAbsolutePath();
        Path path = schematicPath.resolve(playerSchematicId).normalize();
        if (!path.startsWith(schematicPath)) {
            Create.LOGGER.warn("Attempted Schematic Upload with directory escape: {}", (Object)playerSchematicId);
            return;
        }
        if (!AllItems.SCHEMATIC_AND_QUILL.isIn(player.method_6047())) {
            return;
        }
        Path playerSchematics = Paths.get(playerPath, new String[0]);
        if (!this.tryDeleteOldestSchematic(playerSchematics)) {
            return;
        }
        SchematicExport.SchematicExportResult result = SchematicExport.saveSchematic(playerSchematics, schematic, true, world, pos, pos.method_10081((class_2382)bounds).method_10069(-1, -1, -1));
        if (result != null) {
            player.method_6122(class_1268.field_5808, SchematicItem.create((class_7871<class_2248>)world.method_45448(class_7924.field_41254), schematic, playerName));
        } else {
            Lang.translate("schematicAndQuill.instant_failed", new Object[0]).style(class_124.field_1061).sendStatus((class_1657)player);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryDeleteOldestSchematic(Path dir) {
        try (Stream<Path> stream = Files.list(dir);){
            List<Path> files = stream.toList();
            if (files.size() < (Integer)this.getConfig().maxSchematics.get()) {
                boolean bl2 = true;
                return bl2;
            }
            Optional<Path> oldest = files.stream().min(Comparator.comparingLong(this::getLastModifiedTime));
            Files.delete(oldest.orElseThrow());
            boolean bl = true;
            return bl;
        }
        catch (IOException | IllegalStateException e) {
            Create.LOGGER.error("Error deleting oldest schematic", (Throwable)e);
            return false;
        }
    }

    private long getLastModifiedTime(Path file) {
        try {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            Create.LOGGER.error("Error getting modification time of file " + file.getFileName(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public class SchematicUploadEntry {
        public class_1937 world;
        public class_2338 tablePos;
        public OutputStream stream;
        public long bytesUploaded;
        public long totalBytes;
        public int idleTime;

        public SchematicUploadEntry(OutputStream stream, long totalBytes, class_1937 world, class_2338 tablePos) {
            this.stream = stream;
            this.totalBytes = totalBytes;
            this.tablePos = tablePos;
            this.world = world;
            this.bytesUploaded = 0L;
            this.idleTime = 0;
        }
    }
}

