/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.Create;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.redstone.displayLink.source.ComputerDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.DeathCounterDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.EnchantPowerDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.RedstonePowerDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.ScoreboardDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.LecternDisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.SignDisplayTarget;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class AllDisplayBehaviours {
    public static final Map<class_2960, DisplayBehaviour> GATHERER_BEHAVIOURS = new HashMap<class_2960, DisplayBehaviour>();
    private static final AttachedRegistry<class_2248, List<DisplaySource>> SOURCES_BY_BLOCK = new AttachedRegistry(class_7923.field_41175);
    private static final AttachedRegistry<class_2591<?>, List<DisplaySource>> SOURCES_BY_BLOCK_ENTITY = new AttachedRegistry(class_7923.field_41181);
    private static final AttachedRegistry<class_2248, DisplayTarget> TARGETS_BY_BLOCK = new AttachedRegistry(class_7923.field_41175);
    private static final AttachedRegistry<class_2591<?>, DisplayTarget> TARGETS_BY_BLOCK_ENTITY = new AttachedRegistry(class_7923.field_41181);

    public static DisplayBehaviour register(class_2960 id, DisplayBehaviour behaviour) {
        behaviour.id = id;
        GATHERER_BEHAVIOURS.put(id, behaviour);
        return behaviour;
    }

    public static void assignBlock(DisplayBehaviour behaviour, class_2960 block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK.get((class_2248)block);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK.register((class_2248)block, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.register((class_2248)block, target);
        }
    }

    public static void assignBlockEntity(DisplayBehaviour behaviour, class_2960 beType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK_ENTITY.get((class_2591<?>)beType);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK_ENTITY.register((class_2591<?>)beType, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK_ENTITY.register((class_2591<?>)beType, target);
        }
    }

    public static void assignBlock(DisplayBehaviour behaviour, class_2248 block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK.get(block);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK.register(block, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.register(block, target);
        }
    }

    public static void assignBlockEntity(DisplayBehaviour behaviour, class_2591<?> beType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK_ENTITY.get(beType);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK_ENTITY.register(beType, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK_ENTITY.register(beType, target);
        }
    }

    public static <B extends class_2248> NonNullConsumer<? super B> assignDataBehaviour(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            class_2960 registryName = RegisteredObjects.getKeyOrThrow(b);
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(new class_2960(registryName.method_12836(), registryName.method_12832() + (String)idSuffix), behaviour), registryName);
        };
    }

    public static <B extends class_2591<?>> NonNullConsumer<? super B> assignDataBehaviourBE(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            class_2960 registryName = RegisteredObjects.getKeyOrThrow(b);
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(new class_2960(registryName.method_12836(), registryName.method_12832() + (String)idSuffix), behaviour), registryName);
        };
    }

    @Nullable
    public static DisplaySource getSource(class_2960 resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)available;
            return source;
        }
        return null;
    }

    @Nullable
    public static DisplayTarget getTarget(class_2960 resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)available;
            return target;
        }
        return null;
    }

    public static List<DisplaySource> sourcesOf(class_2248 block) {
        List<DisplaySource> sources = SOURCES_BY_BLOCK.get(block);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    public static List<DisplaySource> sourcesOf(class_2680 state) {
        return AllDisplayBehaviours.sourcesOf(state.method_26204());
    }

    public static List<DisplaySource> sourcesOf(class_2591<?> blockEntityType) {
        List<DisplaySource> sources = SOURCES_BY_BLOCK_ENTITY.get(blockEntityType);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    public static List<DisplaySource> sourcesOf(class_2586 blockEntity) {
        return AllDisplayBehaviours.sourcesOf(blockEntity.method_11017());
    }

    @Nullable
    public static DisplayTarget targetOf(class_2248 block) {
        return TARGETS_BY_BLOCK.get(block);
    }

    @Nullable
    public static DisplayTarget targetOf(class_2680 state) {
        return AllDisplayBehaviours.targetOf(state.method_26204());
    }

    @Nullable
    public static DisplayTarget targetOf(class_2591<?> blockEntityType) {
        return TARGETS_BY_BLOCK_ENTITY.get(blockEntityType);
    }

    @Nullable
    public static DisplayTarget targetOf(class_2586 blockEntity) {
        return AllDisplayBehaviours.targetOf(blockEntity.method_11017());
    }

    public static List<DisplaySource> sourcesOf(class_1936 level, class_2338 pos) {
        List<Object> sourcesOfBlockEntity;
        class_2680 blockState = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        List<DisplaySource> sourcesOfBlock = AllDisplayBehaviours.sourcesOf(blockState);
        List<Object> list = sourcesOfBlockEntity = blockEntity == null ? Collections.emptyList() : AllDisplayBehaviours.sourcesOf(blockEntity);
        if (sourcesOfBlockEntity.isEmpty()) {
            return sourcesOfBlock;
        }
        return sourcesOfBlockEntity;
    }

    @Nullable
    public static DisplayTarget targetOf(class_1936 level, class_2338 pos) {
        DisplayTarget targetOfBlockEntity;
        class_2680 blockState = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        DisplayTarget targetOfBlock = AllDisplayBehaviours.targetOf(blockState);
        DisplayTarget displayTarget = targetOfBlockEntity = blockEntity == null ? null : AllDisplayBehaviours.targetOf(blockEntity);
        if (targetOfBlockEntity == null && blockEntity instanceof class_2625) {
            targetOfBlockEntity = AllDisplayBehaviours.targetOf(class_2591.field_11911);
        }
        if (targetOfBlockEntity == null) {
            return targetOfBlock;
        }
        return targetOfBlockEntity;
    }

    public static void registerDefaults() {
        AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(Create.asResource("sign_display_target"), new SignDisplayTarget()), class_2591.field_11911);
        AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(Create.asResource("lectern_display_target"), new LecternDisplayTarget()), class_2591.field_16412);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("death_count_display_source"), new DeathCounterDisplaySource()), class_2246.field_23152);
        AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(Create.asResource("scoreboard_display_source"), new ScoreboardDisplaySource()), class_2591.field_11904);
        AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(Create.asResource("enchant_power_display_source"), new EnchantPowerDisplaySource()), class_2591.field_11912);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("redstone_power_display_source"), new RedstonePowerDisplaySource()), class_2246.field_22422);
        Mods.COMPUTERCRAFT.executeIfInstalled(() -> () -> {
            DisplayBehaviour computerDisplaySource = AllDisplayBehaviours.register(Create.asResource("computer_display_source"), new ComputerDisplaySource());
            AllDisplayBehaviours.assignBlockEntity(computerDisplaySource, new class_2960(Mods.COMPUTERCRAFT.asId(), "wired_modem_full"));
            AllDisplayBehaviours.assignBlockEntity(computerDisplaySource, new class_2960(Mods.COMPUTERCRAFT.asId(), "computer_normal"));
            AllDisplayBehaviours.assignBlockEntity(computerDisplaySource, new class_2960(Mods.COMPUTERCRAFT.asId(), "computer_advanced"));
            AllDisplayBehaviours.assignBlockEntity(computerDisplaySource, new class_2960(Mods.COMPUTERCRAFT.asId(), "computer_command"));
        });
    }
}

