/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.analogLever;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.Rotate;
import com.jozufozu.flywheel.util.transform.Translate;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlock;
import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2738;
import net.minecraft.class_2769;

public class AnalogLeverInstance
extends BlockEntityInstance<AnalogLeverBlockEntity>
implements DynamicInstance {
    protected final ModelData handle;
    protected final ModelData indicator;
    final float rX;
    final float rY;

    public AnalogLeverInstance(MaterialManager materialManager, AnalogLeverBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        Material mat = this.getTransformMaterial();
        this.handle = (ModelData)mat.getModel(AllPartialModels.ANALOG_LEVER_HANDLE, this.blockState).createInstance();
        this.indicator = (ModelData)mat.getModel(AllPartialModels.ANALOG_LEVER_INDICATOR, this.blockState).createInstance();
        this.transform(this.indicator);
        class_2738 face = (class_2738)this.blockState.method_11654((class_2769)AnalogLeverBlock.field_11007);
        this.rX = face == class_2738.field_12475 ? 0.0f : (face == class_2738.field_12471 ? 90.0f : 180.0f);
        this.rY = AngleHelper.horizontalAngle((class_2350)this.blockState.method_11654((class_2769)AnalogLeverBlock.field_11177));
        this.animateLever();
    }

    public void beginFrame() {
        if (!((AnalogLeverBlockEntity)this.blockEntity).clientState.settled()) {
            this.animateLever();
        }
    }

    protected void animateLever() {
        float state = ((AnalogLeverBlockEntity)this.blockEntity).clientState.getValue(AnimationTickHolder.getPartialTicks());
        this.indicator.setColor(Color.mixColors(2884352, 0xCD0000, state / 15.0f));
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        ((ModelData)this.transform(this.handle.loadIdentity()).translate(0.5, 0.0625, 0.5).rotate(class_2350.field_11034, angle)).translate(-0.5, -0.0625, -0.5);
    }

    public void remove() {
        this.handle.delete();
        this.indicator.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.handle, this.indicator});
    }

    private <T extends Translate<T> & Rotate<T>> T transform(T msr) {
        return (T)((Translate)((Translate)((Rotate)((Translate)((Rotate)((Translate)((Translate)msr.translate((class_2382)this.getInstancePosition())).centre())).rotate(class_2350.field_11036, (float)((double)(this.rY / 180.0f) * Math.PI)))).rotate(class_2350.field_11034, (float)((double)(this.rX / 180.0f) * Math.PI))).unCentre());
    }
}

