/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandler;
import com.simibubi.create.content.equipment.toolbox.ToolboxInventory;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class ToolboxEquipPacket
extends SimplePacketBase {
    private class_2338 toolboxPos;
    private int slot;
    private int hotbarSlot;

    public ToolboxEquipPacket(class_2338 toolboxPos, int slot, int hotbarSlot) {
        this.toolboxPos = toolboxPos;
        this.slot = slot;
        this.hotbarSlot = hotbarSlot;
    }

    public ToolboxEquipPacket(class_2540 buffer) {
        if (buffer.readBoolean()) {
            this.toolboxPos = buffer.method_10811();
        }
        this.slot = buffer.method_10816();
        this.hotbarSlot = buffer.method_10816();
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.writeBoolean(this.toolboxPos != null);
        if (this.toolboxPos != null) {
            buffer.method_10807(this.toolboxPos);
        }
        buffer.method_10804(this.slot);
        buffer.method_10804(this.hotbarSlot);
    }

    @Override
    public boolean handle(SimplePacketBase.Context context) {
        context.enqueueWork(() -> {
            class_3222 player = context.getSender();
            class_1937 world = player.method_37908();
            if (this.toolboxPos == null) {
                ToolboxHandler.unequip((class_1657)player, this.hotbarSlot, false);
                ToolboxHandler.syncData((class_1657)player);
                return;
            }
            class_2586 blockEntity = world.method_8321(this.toolboxPos);
            double maxRange = ToolboxHandler.getMaxRange((class_1657)player);
            if (player.method_5649((double)this.toolboxPos.method_10263() + 0.5, (double)this.toolboxPos.method_10264(), (double)this.toolboxPos.method_10260() + 0.5) > maxRange * maxRange) {
                return;
            }
            if (!(blockEntity instanceof ToolboxBlockEntity)) {
                return;
            }
            ToolboxHandler.unequip((class_1657)player, this.hotbarSlot, false);
            if (this.slot < 0 || this.slot >= 8) {
                ToolboxHandler.syncData((class_1657)player);
                return;
            }
            ToolboxBlockEntity toolboxBlockEntity = (ToolboxBlockEntity)blockEntity;
            class_1799 playerStack = player.method_31548().method_5438(this.hotbarSlot);
            if (!playerStack.method_7960() && !ToolboxInventory.canItemsShareCompartment(playerStack, toolboxBlockEntity.inventory.filters.get(this.slot))) {
                toolboxBlockEntity.inventory.inLimitedMode(inventory -> {
                    try (Transaction t = TransferUtil.getTransaction();){
                        long remainder;
                        ItemVariant stack = ItemVariant.of((class_1799)playerStack);
                        long count = playerStack.method_7947();
                        long inserted = inventory.insert(stack, count, (TransactionContext)t);
                        if (inserted != count) {
                            inserted += TransferUtil.insertToMainInv((class_1657)player, (ItemVariant)stack, (long)(count - inserted));
                        }
                        if ((remainder = count - inserted) != count) {
                            t.commit();
                            class_1799 newStack = player.method_32318(this.hotbarSlot).method_32327().method_7972();
                            newStack.method_7939((int)remainder);
                            player.method_31548().method_5447(this.hotbarSlot, newStack);
                        }
                    }
                });
            }
            class_2487 compound = player.getCustomData().method_10562("CreateToolboxData");
            String key = String.valueOf(this.hotbarSlot);
            class_2487 data = new class_2487();
            data.method_10569("Slot", this.slot);
            data.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)this.toolboxPos));
            compound.method_10566(key, (class_2520)data);
            player.getCustomData().method_10566("CreateToolboxData", (class_2520)compound);
            toolboxBlockEntity.connectPlayer(this.slot, (class_1657)player, this.hotbarSlot);
            ToolboxHandler.syncData((class_1657)player);
        });
        return true;
    }
}

