/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.blueprint;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.blueprint.BlueprintEntity;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.content.trains.track.TrackPlacement;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8566;

public class BlueprintOverlayRenderer {
    static boolean active;
    static boolean empty;
    static boolean noOutput;
    static boolean lastSneakState;
    static BlueprintEntity.BlueprintSection lastTargetedSection;
    static Map<class_1799, class_1799[]> cachedRenderedFilters;
    static List<Pair<class_1799, Boolean>> ingredients;
    static class_1799 result;
    static boolean resultCraftable;

    public static void tick() {
        class_310 mc = class_310.method_1551();
        BlueprintEntity.BlueprintSection last = lastTargetedSection;
        lastTargetedSection = null;
        active = false;
        noOutput = false;
        if (mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        class_239 mouseOver = mc.field_1765;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.method_17783() != class_239.class_240.field_1331) {
            return;
        }
        class_3966 entityRay = (class_3966)mouseOver;
        if (!(entityRay.method_17782() instanceof BlueprintEntity)) {
            return;
        }
        BlueprintEntity blueprintEntity = (BlueprintEntity)entityRay.method_17782();
        BlueprintEntity.BlueprintSection sectionAt = blueprintEntity.getSectionAt(entityRay.method_17784().method_1020(blueprintEntity.method_19538()));
        lastTargetedSection = last;
        active = true;
        boolean sneak = mc.field_1724.method_5715();
        if (sectionAt != lastTargetedSection || AnimationTickHolder.getTicks() % 10 == 0 || lastSneakState != sneak) {
            BlueprintOverlayRenderer.rebuild(sectionAt, sneak);
        }
        lastTargetedSection = sectionAt;
        lastSneakState = sneak;
    }

    public static void displayTrackRequirements(TrackPlacement.PlacementInfo info, class_1799 pavementItem) {
        if (active) {
            return;
        }
        active = true;
        empty = false;
        noOutput = true;
        ingredients.clear();
        for (int tracks = info.requiredTracks; tracks > 0; tracks -= 64) {
            ingredients.add(Pair.of(new class_1799((class_1935)info.trackMaterial.getBlock(), Math.min(64, tracks)), info.hasRequiredTracks));
        }
        for (int pavement = info.requiredPavement; pavement > 0; pavement -= 64) {
            ingredients.add(Pair.of(ItemHandlerHelper.copyStackWithSize((class_1799)pavementItem, (int)Math.min(64, pavement)), info.hasRequiredPavement));
        }
    }

    public static void rebuild(BlueprintEntity.BlueprintSection sectionAt, boolean sneak) {
        int i;
        cachedRenderedFilters.clear();
        ItemStackHandler items = sectionAt.getItems();
        boolean empty = true;
        for (int i2 = 0; i2 < 9; ++i2) {
            if (items.getStackInSlot(i2).method_7960()) continue;
            empty = false;
            break;
        }
        BlueprintOverlayRenderer.empty = empty;
        result = class_1799.field_8037;
        if (empty) {
            return;
        }
        boolean firstPass = true;
        boolean success = true;
        class_310 mc = class_310.method_1551();
        PlayerInventoryStorage playerInv = PlayerInventoryStorage.of((class_1657)mc.field_1724);
        int amountCrafted = 0;
        Optional recipe = Optional.empty();
        HashMap<Integer, class_1799> craftingGrid = new HashMap<Integer, class_1799>();
        ingredients.clear();
        ItemStackHandler missingItems = new ItemStackHandler(64);
        ItemStackHandler availableItems = new ItemStackHandler(64);
        ArrayList<class_1799> newlyAdded = new ArrayList<class_1799>();
        ArrayList<class_1799> newlyMissing = new ArrayList<class_1799>();
        boolean invalid = false;
        try (Transaction t = TransferUtil.getTransaction();){
            do {
                craftingGrid.clear();
                newlyAdded.clear();
                newlyMissing.clear();
                for (int i3 = 0; i3 < 9; ++i3) {
                    class_1799 requestedItem = items.getStackInSlot(i3);
                    if (requestedItem.method_7960()) {
                        craftingGrid.put(i3, class_1799.field_8037);
                        continue;
                    }
                    ResourceAmount resource = StorageUtil.findExtractableContent((Storage)playerInv, v -> FilterItem.test((class_1937)mc.field_1687, v.toStack(), requestedItem), (TransactionContext)t);
                    if (resource != null) {
                        class_1799 currentItem = ((ItemVariant)resource.resource()).toStack(1);
                        craftingGrid.put(i3, currentItem);
                        newlyAdded.add(currentItem);
                        continue;
                    }
                    success = false;
                    newlyMissing.add(requestedItem);
                }
                if (success) {
                    class_1799 resultFromRecipe;
                    BlueprintEntity.BlueprintCraftingInventory craftingInventory = new BlueprintEntity.BlueprintCraftingInventory(craftingGrid);
                    if (!recipe.isPresent()) {
                        recipe = mc.field_1687.method_8433().method_8132(class_3956.field_17545, (class_1263)craftingInventory, (class_1937)mc.field_1687);
                    }
                    if ((resultFromRecipe = recipe.filter(arg_0 -> BlueprintOverlayRenderer.lambda$rebuild$1((class_8566)craftingInventory, mc, arg_0)).map(arg_0 -> BlueprintOverlayRenderer.lambda$rebuild$2((class_8566)craftingInventory, mc, arg_0)).orElse(class_1799.field_8037)).method_7960()) {
                        if (!recipe.isPresent()) {
                            invalid = true;
                        }
                        success = false;
                    } else if (resultFromRecipe.method_7947() + amountCrafted > 64) {
                        success = false;
                    } else {
                        amountCrafted += resultFromRecipe.method_7947();
                        if (result.method_7960()) {
                            result = resultFromRecipe.method_7972();
                        } else {
                            result.method_7933(resultFromRecipe.method_7947());
                        }
                        resultCraftable = true;
                        firstPass = false;
                    }
                }
                if (success || firstPass) {
                    newlyAdded.forEach(s -> availableItems.insert(ItemVariant.of((class_1799)s), (long)s.method_7947(), (TransactionContext)t));
                    newlyMissing.forEach(s -> missingItems.insert(ItemVariant.of((class_1799)s), (long)s.method_7947(), (TransactionContext)t));
                }
                if (success) continue;
                if (!firstPass) break;
                result = invalid ? class_1799.field_8037 : items.getStackInSlot(9);
                resultCraftable = false;
                break;
            } while (sneak && success);
            t.commit();
        }
        for (i = 0; i < 9; ++i) {
            class_1799 available = availableItems.getStackInSlot(i);
            if (available.method_7960()) continue;
            ingredients.add(Pair.of(available, true));
        }
        for (i = 0; i < 9; ++i) {
            class_1799 missing = missingItems.getStackInSlot(i);
            if (missing.method_7960()) continue;
            ingredients.add(Pair.of(missing, false));
        }
    }

    public static void renderOverlay(class_332 graphics, float partialTicks, class_1041 window) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842) {
            return;
        }
        if (!active || empty) {
            return;
        }
        int w = 21 * ingredients.size();
        if (!noOutput) {
            w += 51;
        }
        int x = (window.method_4486() - w) / 2;
        int y = window.method_4502() - 100;
        for (Pair<class_1799, Boolean> pair : ingredients) {
            RenderSystem.enableBlend();
            (pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).render(graphics, x, y);
            class_1799 itemStack = pair.getFirst();
            String count = pair.getSecond() != false ? null : class_124.field_1065.toString() + itemStack.method_7947();
            BlueprintOverlayRenderer.drawItemStack(graphics, mc, x, y, itemStack, count);
            x += 21;
        }
        if (noOutput) {
            return;
        }
        RenderSystem.enableBlend();
        AllGuiTextures.HOTSLOT_ARROW.render(graphics, x += 5, y + 4);
        x += 25;
        if (result.method_7960()) {
            AllGuiTextures.HOTSLOT.render(graphics, x, y);
            ((RenderElement)GuiGameElement.of((class_1935)class_1802.field_8077).at(x + 3, y + 3)).render(graphics);
        } else {
            (resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT).render(graphics, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
            BlueprintOverlayRenderer.drawItemStack(graphics, mc, x, y, result, null);
        }
        RenderSystem.disableBlend();
    }

    public static void drawItemStack(class_332 graphics, class_310 mc, int x, int y, class_1799 itemStack, String count) {
        if (itemStack.method_7909() instanceof FilterItem) {
            int step = AnimationTickHolder.getTicks((class_1936)mc.field_1687) / 10;
            class_1799[] itemsMatchingFilter = BlueprintOverlayRenderer.getItemsMatchingFilter(itemStack);
            if (itemsMatchingFilter.length > 0) {
                itemStack = itemsMatchingFilter[step % itemsMatchingFilter.length];
            }
        }
        ((RenderElement)GuiGameElement.of(itemStack).at(x + 3, y + 3)).render(graphics);
        graphics.method_51432(mc.field_1772, itemStack, x + 3, y + 3, count);
    }

    private static class_1799[] getItemsMatchingFilter(class_1799 filter) {
        return cachedRenderedFilters.computeIfAbsent(filter, itemStack -> {
            class_2487 tag = itemStack.method_7948();
            if (AllItems.FILTER.isIn(itemStack) && !tag.method_10577("Blacklist")) {
                ItemStackHandler filterItems = FilterItem.getFilterItems(itemStack);
                ArrayList<class_1799> list = new ArrayList<class_1799>();
                for (int slot = 0; slot < filterItems.getSlotCount(); ++slot) {
                    class_1799 stackInSlot = filterItems.getStackInSlot(slot);
                    if (stackInSlot.method_7960()) continue;
                    list.add(stackInSlot);
                }
                return list.toArray(new class_1799[list.size()]);
            }
            if (AllItems.ATTRIBUTE_FILTER.isIn(itemStack)) {
                ItemAttribute fromNBT;
                AttributeFilterMenu.WhitelistMode whitelistMode = AttributeFilterMenu.WhitelistMode.values()[tag.method_10550("WhitelistMode")];
                class_2499 attributes = tag.method_10554("MatchedAttributes", 10);
                if (whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ && attributes.size() == 1 && (fromNBT = ItemAttribute.fromNBT((class_2487)attributes.method_10534(0))) instanceof ItemAttribute.InTag) {
                    ItemAttribute.InTag inTag = (ItemAttribute.InTag)fromNBT;
                    ArrayList<class_1799> stacks = new ArrayList<class_1799>();
                    for (class_6880 holder : class_7923.field_41178.method_40286(inTag.tag)) {
                        stacks.add(new class_1799((class_1935)holder.comp_349()));
                    }
                    return (class_1799[])stacks.toArray(class_1799[]::new);
                }
            }
            return new class_1799[0];
        });
    }

    private static /* synthetic */ class_1799 lambda$rebuild$2(class_8566 craftingInventory, class_310 mc, class_3955 r) {
        return r.method_8116((class_1263)craftingInventory, mc.field_1687.method_30349());
    }

    private static /* synthetic */ boolean lambda$rebuild$1(class_8566 craftingInventory, class_310 mc, class_3955 r) {
        return r.method_8115((class_1263)craftingInventory, (class_1937)mc.field_1687);
    }

    static {
        cachedRenderedFilters = new IdentityHashMap<class_1799, class_1799[]>();
        ingredients = new ArrayList<Pair<class_1799, Boolean>>();
        result = class_1799.field_8037;
        resultCraftable = false;
    }
}

