/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.minecart;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.fabric.ListeningStorageView;
import com.simibubi.create.foundation.utility.fabric.ProcessingIterator;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3902;

public class TrainCargoManager
extends MountedStorageManager {
    int ticksSinceLastExchange = 0;
    AtomicInteger version = new AtomicInteger();

    @Override
    public void createHandlers() {
        super.createHandlers();
    }

    @Override
    protected Contraption.ContraptionInvWrapper wrapItems(Collection<? extends Storage<ItemVariant>> list, boolean fuel) {
        if (fuel) {
            return super.wrapItems(list, fuel);
        }
        return new CargoInvWrapper((Storage[])Arrays.copyOf(list.toArray(), list.size(), Storage[].class));
    }

    @Override
    protected CombinedTankWrapper wrapFluids(Collection<? extends Storage<FluidVariant>> list) {
        return new CargoTankWrapper((Storage[])Arrays.copyOf(list.toArray(), list.size(), Storage[].class));
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.method_10569("TicksSinceLastExchange", this.ticksSinceLastExchange);
    }

    @Override
    public void read(class_2487 nbt, Map<class_2338, class_2586> presentBlockEntities, boolean clientPacket) {
        super.read(nbt, presentBlockEntities, clientPacket);
        this.ticksSinceLastExchange = nbt.method_10550("TicksSinceLastExchange");
    }

    public void resetIdleCargoTracker() {
        this.ticksSinceLastExchange = 0;
    }

    public void tickIdleCargoTracker() {
        ++this.ticksSinceLastExchange;
    }

    public int getTicksSinceLastExchange() {
        return this.ticksSinceLastExchange;
    }

    public int getVersion() {
        return this.version.get();
    }

    void changeDetected() {
        this.version.incrementAndGet();
        this.resetIdleCargoTracker();
    }

    class CargoInvWrapper
    extends Contraption.ContraptionInvWrapper {
        public CargoInvWrapper(Storage<ItemVariant> ... itemHandler) {
            super(false, itemHandler);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert((Object)resource, maxAmount, transaction);
            if (inserted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, TrainCargoManager.this::changeDetected);
            }
            return inserted;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long extracted = super.extract((Object)resource, maxAmount, transaction);
            if (extracted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, TrainCargoManager.this::changeDetected);
            }
            return extracted;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            return new ProcessingIterator<StorageView<ItemVariant>>(super.iterator(), view -> new ListeningStorageView(view, TrainCargoManager.this::changeDetected));
        }
    }

    class CargoTankWrapper
    extends CombinedTankWrapper {
        public final SnapshotParticipant<class_3902> successListener;

        public CargoTankWrapper(Storage<FluidVariant> ... fluidHandler) {
            super(fluidHandler);
            this.successListener = new SnapshotParticipant<class_3902>(){

                protected class_3902 createSnapshot() {
                    return class_3902.field_17274;
                }

                protected void readSnapshot(class_3902 snapshot) {
                }

                protected void onFinalCommit() {
                    super.onFinalCommit();
                    TrainCargoManager.this.changeDetected();
                }
            };
        }

        @Override
        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert(resource, maxAmount, transaction);
            if (inserted != 0L) {
                this.successListener.updateSnapshots(transaction);
            }
            return inserted;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            long extracted = super.extract((Object)resource, maxAmount, transaction);
            if (extracted != 0L) {
                this.successListener.updateSnapshots(transaction);
            }
            return extracted;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            return super.iterator();
        }
    }
}

