/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.contraptions.ContraptionMovementSetting;
import com.simibubi.create.content.contraptions.actors.AttachedActorBlock;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.bearing.ClockworkBearingBlock;
import com.simibubi.create.content.contraptions.bearing.ClockworkBearingBlockEntity;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlock;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.bearing.SailBlock;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.kinetics.crank.HandCrankBlock;
import com.simibubi.create.content.kinetics.fan.NozzleBlock;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2231;
import net.minecraft.class_2241;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2383;
import net.minecraft.class_2399;
import net.minecraft.class_2457;
import net.minecraft.class_2458;
import net.minecraft.class_2478;
import net.minecraft.class_2508;
import net.minecraft.class_2527;
import net.minecraft.class_2551;
import net.minecraft.class_2555;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3619;
import net.minecraft.class_3709;
import net.minecraft.class_3713;
import net.minecraft.class_3867;
import net.minecraft.class_5815;

public class BlockMovementChecks {
    private static final List<MovementNecessaryCheck> MOVEMENT_NECESSARY_CHECKS = new ArrayList<MovementNecessaryCheck>();
    private static final List<MovementAllowedCheck> MOVEMENT_ALLOWED_CHECKS = new ArrayList<MovementAllowedCheck>();
    private static final List<BrittleCheck> BRITTLE_CHECKS = new ArrayList<BrittleCheck>();
    private static final List<AttachedCheck> ATTACHED_CHECKS = new ArrayList<AttachedCheck>();
    private static final List<NotSupportiveCheck> NOT_SUPPORTIVE_CHECKS = new ArrayList<NotSupportiveCheck>();

    public static void registerMovementNecessaryCheck(MovementNecessaryCheck check) {
        MOVEMENT_NECESSARY_CHECKS.add(0, check);
    }

    public static void registerMovementAllowedCheck(MovementAllowedCheck check) {
        MOVEMENT_ALLOWED_CHECKS.add(0, check);
    }

    public static void registerBrittleCheck(BrittleCheck check) {
        BRITTLE_CHECKS.add(0, check);
    }

    public static void registerAttachedCheck(AttachedCheck check) {
        ATTACHED_CHECKS.add(0, check);
    }

    public static void registerNotSupportiveCheck(NotSupportiveCheck check) {
        NOT_SUPPORTIVE_CHECKS.add(0, check);
    }

    public static void registerAllChecks(AllChecks checks) {
        BlockMovementChecks.registerMovementNecessaryCheck(checks);
        BlockMovementChecks.registerMovementAllowedCheck(checks);
        BlockMovementChecks.registerBrittleCheck(checks);
        BlockMovementChecks.registerAttachedCheck(checks);
        BlockMovementChecks.registerNotSupportiveCheck(checks);
    }

    public static boolean isMovementNecessary(class_2680 state, class_1937 world, class_2338 pos) {
        for (MovementNecessaryCheck check : MOVEMENT_NECESSARY_CHECKS) {
            CheckResult result = check.isMovementNecessary(state, world, pos);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isMovementNecessaryFallback(state, world, pos);
    }

    public static boolean isMovementAllowed(class_2680 state, class_1937 world, class_2338 pos) {
        for (MovementAllowedCheck check : MOVEMENT_ALLOWED_CHECKS) {
            CheckResult result = check.isMovementAllowed(state, world, pos);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isMovementAllowedFallback(state, world, pos);
    }

    public static boolean isBrittle(class_2680 state) {
        for (BrittleCheck check : BRITTLE_CHECKS) {
            CheckResult result = check.isBrittle(state);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isBrittleFallback(state);
    }

    public static boolean isBlockAttachedTowards(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        for (AttachedCheck check : ATTACHED_CHECKS) {
            CheckResult result = check.isBlockAttachedTowards(state, world, pos, direction);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isBlockAttachedTowardsFallback(state, world, pos, direction);
    }

    public static boolean isNotSupportive(class_2680 state, class_2350 facing) {
        for (NotSupportiveCheck check : NOT_SUPPORTIVE_CHECKS) {
            CheckResult result = check.isNotSupportive(state, facing);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isNotSupportiveFallback(state, facing);
    }

    private static boolean isMovementNecessaryFallback(class_2680 state, class_1937 world, class_2338 pos) {
        if (BlockMovementChecks.isBrittle(state)) {
            return true;
        }
        if (AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.matches(state)) {
            return true;
        }
        if (state.method_26220((class_1922)world, pos).method_1110()) {
            return false;
        }
        return !state.method_45474();
    }

    private static boolean isMovementAllowedFallback(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 be;
        class_2248 block = state.method_26204();
        if (block instanceof AbstractChassisBlock) {
            return true;
        }
        if (state.method_26214((class_1922)world, pos) == -1.0f) {
            return false;
        }
        if (AllTags.AllBlockTags.RELOCATION_NOT_SUPPORTED.matches(state)) {
            return false;
        }
        if (AllTags.AllBlockTags.NON_MOVABLE.matches(state)) {
            return false;
        }
        if (ContraptionMovementSetting.get(state.method_26204()) == ContraptionMovementSetting.UNMOVABLE) {
            return false;
        }
        if (block instanceof MechanicalPistonBlock && state.method_11654(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.MOVING) {
            return true;
        }
        if (block instanceof MechanicalBearingBlock && (be = world.method_8321(pos)) instanceof MechanicalBearingBlockEntity) {
            return !((MechanicalBearingBlockEntity)be).isRunning();
        }
        if (block instanceof ClockworkBearingBlock && (be = world.method_8321(pos)) instanceof ClockworkBearingBlockEntity) {
            return !((ClockworkBearingBlockEntity)be).isRunning();
        }
        if (block instanceof PulleyBlock && (be = world.method_8321(pos)) instanceof PulleyBlockEntity) {
            return !((PulleyBlockEntity)be).running;
        }
        if (AllBlocks.BELT.has(state)) {
            return true;
        }
        if (state.method_26204() instanceof class_3713) {
            return true;
        }
        if (state.method_26204() instanceof ITrackBlock) {
            return false;
        }
        if (state.method_26204() instanceof StationBlock) {
            return false;
        }
        return state.method_26223() != class_3619.field_15972;
    }

    private static boolean isBrittleFallback(class_2680 state) {
        class_2248 block = state.method_26204();
        if (state.method_28498((class_2769)class_2741.field_16561)) {
            return true;
        }
        if (block instanceof class_2399) {
            return true;
        }
        if (block instanceof class_2527) {
            return true;
        }
        if (block instanceof class_2478) {
            return true;
        }
        if (block instanceof class_2231) {
            return true;
        }
        if (block instanceof class_2341 && !(block instanceof class_3713)) {
            return true;
        }
        if (block instanceof CartAssemblerBlock) {
            return false;
        }
        if (block instanceof class_2241) {
            return true;
        }
        if (block instanceof class_2312) {
            return true;
        }
        if (block instanceof class_2457) {
            return true;
        }
        if (block instanceof class_5815) {
            return true;
        }
        if (block instanceof WhistleBlock) {
            return true;
        }
        if (block instanceof WhistleExtenderBlock) {
            return true;
        }
        return AllTags.AllBlockTags.BRITTLE.matches(state);
    }

    private static boolean isBlockAttachedTowardsFallback(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2399) {
            return state.method_11654((class_2769)class_2399.field_11253) == direction.method_10153();
        }
        if (block instanceof class_2555) {
            return state.method_11654((class_2769)class_2555.field_11731) == direction.method_10153();
        }
        if (block instanceof class_2551) {
            return state.method_11654((class_2769)class_2551.field_11726) == direction.method_10153();
        }
        if (block instanceof class_2508) {
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_2231) {
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_2323) {
            if (state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12607 && direction == class_2350.field_11036) {
                return true;
            }
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_2244) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2244.field_11177);
            if (state.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560) {
                facing = facing.method_10153();
            }
            return direction == facing;
        }
        if (block instanceof RedstoneLinkBlock) {
            return direction.method_10153() == state.method_11654((class_2769)RedstoneLinkBlock.field_10927);
        }
        if (block instanceof class_2362) {
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_2312) {
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_2457) {
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_5815) {
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_2458) {
            return state.method_11654((class_2769)class_2458.field_11443) == direction.method_10153();
        }
        if (block instanceof class_2527) {
            return direction == class_2350.field_11033;
        }
        if (block instanceof class_2341) {
            class_2738 attachFace = (class_2738)state.method_11654((class_2769)class_2341.field_11007);
            if (attachFace == class_2738.field_12473) {
                return direction == class_2350.field_11036;
            }
            if (attachFace == class_2738.field_12475) {
                return direction == class_2350.field_11033;
            }
            if (attachFace == class_2738.field_12471) {
                return direction.method_10153() == state.method_11654((class_2769)class_2341.field_11177);
            }
        }
        if (state.method_28498((class_2769)class_2741.field_16561)) {
            return direction == ((Boolean)state.method_11654((class_2769)class_2741.field_16561) != false ? class_2350.field_11036 : class_2350.field_11033);
        }
        if (block instanceof class_2241) {
            return direction == class_2350.field_11033;
        }
        if (block instanceof AttachedActorBlock) {
            return direction == ((class_2350)state.method_11654((class_2769)HarvesterBlock.field_11177)).method_10153();
        }
        if (block instanceof HandCrankBlock) {
            return direction == ((class_2350)state.method_11654((class_2769)HandCrankBlock.FACING)).method_10153();
        }
        if (block instanceof NozzleBlock) {
            return direction == ((class_2350)state.method_11654((class_2769)NozzleBlock.field_10927)).method_10153();
        }
        if (block instanceof class_3709) {
            class_3867 attachment = (class_3867)state.method_11654((class_2769)class_2741.field_17104);
            if (attachment == class_3867.field_17098) {
                return direction == class_2350.field_11033;
            }
            if (attachment == class_3867.field_17099) {
                return direction == class_2350.field_11036;
            }
            return direction == state.method_11654((class_2769)class_2383.field_11177);
        }
        if (state.method_26204() instanceof SailBlock) {
            return direction.method_10166() != ((class_2350)state.method_11654((class_2769)SailBlock.field_10927)).method_10166();
        }
        if (state.method_26204() instanceof FluidTankBlock) {
            return ConnectivityHandler.isConnected((class_1922)world, pos, pos.method_10093(direction));
        }
        if (state.method_26204() instanceof ItemVaultBlock) {
            return ConnectivityHandler.isConnected((class_1922)world, pos, pos.method_10093(direction));
        }
        if (AllBlocks.STICKER.has(state) && ((Boolean)state.method_11654((class_2769)StickerBlock.EXTENDED)).booleanValue()) {
            return direction == state.method_11654((class_2769)StickerBlock.field_10927) && !BlockMovementChecks.isNotSupportive(world.method_8320(pos.method_10093(direction)), direction.method_10153());
        }
        if (block instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey = (AbstractBogeyBlock)block;
            return bogey.getStickySurfaces((class_1922)world, pos, state).contains(direction);
        }
        if (block instanceof WhistleBlock) {
            return direction == ((Boolean)state.method_11654((class_2769)WhistleBlock.WALL) != false ? (class_2350)state.method_11654((class_2769)WhistleBlock.FACING) : class_2350.field_11033);
        }
        if (block instanceof WhistleExtenderBlock) {
            return direction == class_2350.field_11033;
        }
        return false;
    }

    private static boolean isNotSupportiveFallback(class_2680 state, class_2350 facing) {
        if (AllBlocks.MECHANICAL_DRILL.has(state)) {
            return state.method_11654((class_2769)class_2741.field_12525) == facing;
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            return state.method_11654((class_2769)class_2741.field_12525) == facing;
        }
        if (AllBlocks.CART_ASSEMBLER.has(state)) {
            return class_2350.field_11033 == facing;
        }
        if (AllBlocks.MECHANICAL_SAW.has(state)) {
            return state.method_11654((class_2769)class_2741.field_12525) == facing;
        }
        if (AllBlocks.PORTABLE_STORAGE_INTERFACE.has(state)) {
            return state.method_11654((class_2769)PortableStorageInterfaceBlock.field_10927) == facing;
        }
        if (state.method_26204() instanceof AttachedActorBlock && !AllBlocks.MECHANICAL_ROLLER.has(state)) {
            return state.method_11654((class_2769)class_2741.field_12481) == facing;
        }
        if (AllBlocks.ROPE_PULLEY.has(state)) {
            return facing == class_2350.field_11033;
        }
        if (state.method_26204() instanceof class_5815) {
            return facing == class_2350.field_11036;
        }
        if (state.method_26204() instanceof SailBlock) {
            return facing.method_10166() == ((class_2350)state.method_11654((class_2769)SailBlock.field_10927)).method_10166();
        }
        if (AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            return facing.method_10166() != ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166();
        }
        if (AllBlocks.MECHANICAL_PISTON_HEAD.has(state)) {
            return facing.method_10166() != ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166();
        }
        if (AllBlocks.STICKER.has(state) && !((Boolean)state.method_11654((class_2769)StickerBlock.EXTENDED)).booleanValue()) {
            return facing == state.method_11654((class_2769)StickerBlock.field_10927);
        }
        if (state.method_26204() instanceof SlidingDoorBlock) {
            return false;
        }
        return BlockMovementChecks.isBrittle(state);
    }

    public static interface MovementNecessaryCheck {
        public CheckResult isMovementNecessary(class_2680 var1, class_1937 var2, class_2338 var3);
    }

    public static interface MovementAllowedCheck {
        public CheckResult isMovementAllowed(class_2680 var1, class_1937 var2, class_2338 var3);
    }

    public static interface BrittleCheck {
        public CheckResult isBrittle(class_2680 var1);
    }

    public static interface AttachedCheck {
        public CheckResult isBlockAttachedTowards(class_2680 var1, class_1937 var2, class_2338 var3, class_2350 var4);
    }

    public static interface NotSupportiveCheck {
        public CheckResult isNotSupportive(class_2680 var1, class_2350 var2);
    }

    public static enum CheckResult {
        SUCCESS,
        FAIL,
        PASS;


        public Boolean toBoolean() {
            return this == PASS ? null : Boolean.valueOf(this == SUCCESS);
        }

        public static CheckResult of(boolean b) {
            return b ? SUCCESS : FAIL;
        }

        public static CheckResult of(Boolean b) {
            return b == null ? PASS : (b != false ? SUCCESS : FAIL);
        }
    }

    public static interface AllChecks
    extends MovementNecessaryCheck,
    MovementAllowedCheck,
    BrittleCheck,
    AttachedCheck,
    NotSupportiveCheck {
    }
}

