/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio.client;

import dark.org.commons.logging.Log;
import dark.org.commons.logging.LogFactory;
import dark.org.http.ConnectionReuseStrategy;
import dark.org.http.HttpHost;
import dark.org.http.client.protocol.HttpClientContext;
import dark.org.http.concurrent.BasicFuture;
import dark.org.http.concurrent.FutureCallback;
import dark.org.http.conn.ConnectionKeepAliveStrategy;
import dark.org.http.impl.DefaultConnectionReuseStrategy;
import dark.org.http.impl.client.DefaultConnectionKeepAliveStrategy;
import dark.org.http.impl.nio.client.CloseableHttpAsyncClientBase;
import dark.org.http.impl.nio.client.FutureWrapper;
import dark.org.http.impl.nio.client.MinimalClientExchangeHandlerImpl;
import dark.org.http.impl.nio.client.PipeliningClientExchangeHandlerImpl;
import dark.org.http.nio.NHttpClientEventHandler;
import dark.org.http.nio.conn.NHttpClientConnectionManager;
import dark.org.http.nio.protocol.HttpAsyncRequestExecutor;
import dark.org.http.nio.protocol.HttpAsyncRequestProducer;
import dark.org.http.nio.protocol.HttpAsyncResponseConsumer;
import dark.org.http.protocol.BasicHttpContext;
import dark.org.http.protocol.HttpContext;
import dark.org.http.protocol.HttpProcessor;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

class MinimalHttpAsyncClient
extends CloseableHttpAsyncClientBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr, ThreadFactory threadFactory, NHttpClientEventHandler eventHandler, HttpProcessor httpProcessor, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy) {
        super(connmgr, threadFactory, eventHandler);
        this.connmgr = connmgr;
        this.httpProcessor = httpProcessor;
        this.connReuseStrategy = connReuseStrategy;
        this.keepaliveStrategy = keepaliveStrategy;
    }

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr, HttpProcessor httpProcessor) {
        this(connmgr, Executors.defaultThreadFactory(), new HttpAsyncRequestExecutor(), httpProcessor, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        this.ensureRunning();
        BasicFuture<T> future = new BasicFuture<T>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        MinimalClientExchangeHandlerImpl<T> handler = new MinimalClientExchangeHandlerImpl<T>(this.log, requestProducer, responseConsumer, localcontext, future, this.connmgr, this.httpProcessor, this.connReuseStrategy, this.keepaliveStrategy);
        try {
            handler.start();
        }
        catch (Exception ex) {
            handler.failed(ex);
        }
        return new FutureWrapper<T>(future, handler);
    }

    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, HttpContext context, FutureCallback<List<T>> callback) {
        this.ensureRunning();
        BasicFuture<List<T>> future = new BasicFuture<List<T>>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        PipeliningClientExchangeHandlerImpl<T> handler = new PipeliningClientExchangeHandlerImpl<T>(this.log, target, requestProducers, responseConsumers, localcontext, future, this.connmgr, this.httpProcessor, this.connReuseStrategy, this.keepaliveStrategy);
        try {
            handler.start();
        }
        catch (Exception ex) {
            handler.failed(ex);
        }
        return new FutureWrapper<List<T>>(future, handler);
    }
}

