/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.cookie;

import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.cookie.CommonCookieAttributeHandler;
import dark.org.http.cookie.Cookie;
import dark.org.http.cookie.CookieOrigin;
import dark.org.http.cookie.MalformedCookieException;
import dark.org.http.cookie.SetCookie;
import dark.org.http.impl.cookie.AbstractCookieAttributeHandler;
import dark.org.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

