/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.client;

import dark.org.http.HttpException;
import dark.org.http.HttpHost;
import dark.org.http.HttpRequest;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.client.ClientProtocolException;
import dark.org.http.client.config.RequestConfig;
import dark.org.http.client.methods.CloseableHttpResponse;
import dark.org.http.client.methods.Configurable;
import dark.org.http.client.methods.HttpExecutionAware;
import dark.org.http.client.methods.HttpRequestWrapper;
import dark.org.http.client.protocol.HttpClientContext;
import dark.org.http.conn.ClientConnectionManager;
import dark.org.http.conn.ClientConnectionRequest;
import dark.org.http.conn.HttpClientConnectionManager;
import dark.org.http.conn.ManagedClientConnection;
import dark.org.http.conn.routing.HttpRoute;
import dark.org.http.conn.scheme.SchemeRegistry;
import dark.org.http.impl.DefaultConnectionReuseStrategy;
import dark.org.http.impl.client.CloseableHttpClient;
import dark.org.http.impl.client.DefaultConnectionKeepAliveStrategy;
import dark.org.http.impl.execchain.MinimalClientExec;
import dark.org.http.params.BasicHttpParams;
import dark.org.http.params.HttpParams;
import dark.org.http.protocol.BasicHttpContext;
import dark.org.http.protocol.HttpContext;
import dark.org.http.protocol.HttpRequestExecutor;
import dark.org.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

