/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.WorldUtils;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class TeleportToPlayerMessage {
    String name;

    public TeleportToPlayerMessage(String name) {
        this.name = name;
    }

    public static void encode(TeleportToPlayerMessage data, PacketBuffer buf) {
        buf.func_180714_a(data.name);
    }

    public static TeleportToPlayerMessage decode(PacketBuffer buf) {
        return new TeleportToPlayerMessage(buf.func_150789_c(100));
    }

    public static void handle(TeleportToPlayerMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (!player.func_211513_k(2)) {
                return;
            }
            World ori = player.func_130014_f_();
            AtomicReference dest = new AtomicReference();
            AtomicReference otherPos = new AtomicReference();
            WorldUtils.applyToPlayer(data.name, player.field_71133_b, o -> {
                dest.set(o.func_130014_f_());
                otherPos.set(o.func_233580_cy_());
            });
            if (otherPos.get() == null) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Failed to load Player"), new UUID(0L, 0L));
            }
            WorldUtils.teleportPlayer((PlayerEntity)player, ori, (World)dest.get(), (BlockPos)otherPos.get());
        });
        ctx.get().setPacketHandled(true);
    }
}

