/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class TeleportMessage {
    RegistryKey<World> origin;
    RegistryKey<World> dest;
    BlockPos pos;

    public TeleportMessage(RegistryKey<World> origin, RegistryKey<World> dest, BlockPos pos) {
        this.origin = origin;
        this.dest = dest;
        this.pos = pos;
    }

    public static void encode(TeleportMessage data, PacketBuffer buf) {
        NetworkTools.writeWorldKey(data.origin, buf);
        NetworkTools.writeWorldKey(data.dest, buf);
        buf.func_179255_a(data.pos);
    }

    public static TeleportMessage decode(PacketBuffer buf) {
        return new TeleportMessage(NetworkTools.readWorldKey(buf), NetworkTools.readWorldKey(buf), buf.func_179259_c());
    }

    public static void handle(TeleportMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (!player.func_211513_k(2)) {
                return;
            }
            ServerWorld ori = player.func_184102_h().func_71218_a(data.origin);
            ServerWorld dest = player.func_184102_h().func_71218_a(data.dest);
            WorldUtils.teleportPlayer((PlayerEntity)player, (World)ori, (World)dest, data.pos);
        });
        ctx.get().setPacketHandled(true);
    }
}

