/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.ClearItemTask;
import com.darkere.crashutils.ClientEvents;
import com.darkere.crashutils.CrashUtilCommands.EntityCommands.EntitiesCommands;
import com.darkere.crashutils.CrashUtilCommands.GetLogCommand;
import com.darkere.crashutils.CrashUtilCommands.HelpCommand;
import com.darkere.crashutils.CrashUtilCommands.InventoryCommands.InventoryCommands;
import com.darkere.crashutils.CrashUtilCommands.ItemClearCommand;
import com.darkere.crashutils.CrashUtilCommands.LoadedChunksCommand;
import com.darkere.crashutils.CrashUtilCommands.MemoryCommand;
import com.darkere.crashutils.CrashUtilCommands.PlayerCommands.ActivityCommand;
import com.darkere.crashutils.CrashUtilCommands.PlayerCommands.TeleportCommand;
import com.darkere.crashutils.CrashUtilCommands.PlayerCommands.UnstuckCommand;
import com.darkere.crashutils.CrashUtilCommands.TileEntityCommands.TileEntitiesCommands;
import com.darkere.crashutils.DataStructures.PlayerActivityHistory;
import com.darkere.crashutils.MemoryChecker;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.ServerConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crashutilities")
public class CrashUtils {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "crashutilities";
    public static final ServerConfig SERVER_CONFIG = new ServerConfig();
    public static boolean curiosLoaded = false;
    Timer chunkcleaner;
    public static boolean sparkLoaded = false;
    public static List<Consumer<ServerWorld>> runnables = new CopyOnWriteArrayList<Consumer<ServerWorld>>();
    public static boolean skipNext = false;
    public static boolean isServer = false;

    public CrashUtils() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::common);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::configReload);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)new ClientEvents()));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG.getSpec());
        curiosLoaded = ModList.get().isLoaded("curios");
        sparkLoaded = ModList.get().isLoaded("spark");
    }

    public void client(FMLClientSetupEvent event) {
        ClientEvents.registerKeybindings();
    }

    public void common(FMLCommonSetupEvent event) {
        Network.register();
    }

    public void configReload(ModConfig.Reloading event) {
        ServerWorld world;
        MinecraftServer server;
        if (isServer) {
            ClearItemTask.restart();
            MemoryChecker.restart();
        }
        if ((server = ServerLifecycleHooks.getCurrentServer()) != null && (world = server.func_71218_a(World.field_234918_g_)) != null) {
            this.setupFtbChunksUnloading(world);
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandNode<CommandSource> entitiesCommands = EntitiesCommands.register();
        CommandNode<CommandSource> tileEntitiesCommands = TileEntitiesCommands.register();
        CommandNode<CommandSource> inventoryCommands = InventoryCommands.register();
        LiteralCommandNode cmd = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MODID).requires(x -> x.func_197034_c(2))).then(TeleportCommand.register())).then(UnstuckCommand.register())).then(MemoryCommand.register())).then(ItemClearCommand.register())).then(GetLogCommand.register())).then(HelpCommand.register())).then(LoadedChunksCommand.register())).then(ActivityCommand.register())).then(entitiesCommands)).then(Commands.func_197057_a((String)"entities").redirect(entitiesCommands))).then(Commands.func_197057_a((String)"entity").redirect(entitiesCommands))).then(tileEntitiesCommands)).then(Commands.func_197057_a((String)"te").redirect(tileEntitiesCommands))).then(Commands.func_197057_a((String)"tileentities").redirect(tileEntitiesCommands))).then(Commands.func_197057_a((String)"tileentity").redirect(tileEntitiesCommands))).then(inventoryCommands)).then(Commands.func_197057_a((String)"inventory").redirect(inventoryCommands)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"cu").requires(x -> x.func_197034_c(2))).redirect((CommandNode)cmd));
    }

    @SubscribeEvent
    public void ServerStarted(FMLServerStartedEvent event) {
        isServer = true;
        ClearItemTask.start();
        MemoryChecker.start();
        this.setupFtbChunksUnloading(event.getServer().func_71218_a(World.field_234918_g_));
    }

    private void setupFtbChunksUnloading(final ServerWorld world) {
        if (SERVER_CONFIG.shouldChunksExpire()) {
            this.chunkcleaner = new Timer(true);
            this.chunkcleaner.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    PlayerActivityHistory history = new PlayerActivityHistory(world);
                    LOGGER.info("Unloading chunks for players that have not been online in: " + SERVER_CONFIG.getExpireTimeInDays() + " Days");
                    LOGGER.info(history.getPlayersInChunkClearTime().size() + " Player(s) affected ");
                    for (String player : history.getPlayersInChunkClearTime()) {
                        LOGGER.info("Unloading " + player + "'s Chunks");
                        world.func_73046_m().func_195571_aL().func_197059_a(world.func_73046_m().func_195573_aM(), "ftbchunks unload_all " + player);
                    }
                }
            }, 5L, 3600000L);
        }
    }

    public static void runNextTick(Consumer<ServerWorld> run) {
        runnables.add(run);
    }

    public static void runInTwoTicks(Consumer<ServerWorld> run) {
        runnables.add(run);
        skipNext = true;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.world.field_72995_K && !runnables.isEmpty()) {
            runnables.clear();
            return;
        }
        if (!runnables.isEmpty()) {
            if (skipNext) {
                skipNext = false;
                return;
            }
            runnables.forEach(c -> c.accept((ServerWorld)event.world));
            runnables.clear();
        }
    }
}

