/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.DataStructures.LoadedChunkData;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;

public class LoadedChunksCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"chunks").then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(x -> LoadedChunksCommand.run((CommandContext<CommandSource>)x, 0, null)))).executes(x -> LoadedChunksCommand.run((CommandContext<CommandSource>)x, 0, null))).then(Commands.func_197057_a((String)"byLocation").then(Commands.func_197056_a((String)"loc", (ArgumentType)StringArgumentType.word()).executes(x -> LoadedChunksCommand.run((CommandContext<CommandSource>)x, 1, StringArgumentType.getString((CommandContext)x, (String)"loc")))))).then(Commands.func_197057_a((String)"byTicket").then(Commands.func_197056_a((String)"tic", (ArgumentType)StringArgumentType.word()).executes(x -> LoadedChunksCommand.run((CommandContext<CommandSource>)x, 2, StringArgumentType.getString((CommandContext)x, (String)"tic")))));
    }

    public static int run(CommandContext<CommandSource> context, int type, String word) throws CommandSyntaxException {
        List<ServerWorld> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        LoadedChunkData loadedChunkData = new LoadedChunkData(worlds);
        CrashUtils.runNextTick(world -> LoadedChunksCommand.reply(type, loadedChunkData, context, word));
        return 1;
    }

    public static void reply(int type, LoadedChunkData loadedChunkData, CommandContext<CommandSource> context, String word) {
        try {
            switch (type) {
                case 0: {
                    loadedChunkData.reply((CommandSource)context.getSource());
                    break;
                }
                case 1: {
                    loadedChunkData.replyWithLocation((CommandSource)context.getSource(), word);
                    break;
                }
                case 2: {
                    loadedChunkData.replyWithTicket((CommandSource)context.getSource(), word);
                }
            }
        }
        catch (CommandSyntaxException e) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Exception getting player"), true);
        }
    }
}

