/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.InventoryCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class RemoveFromInventorySlotCommand {
    private static final List<String> invTypes = new ArrayList<String>(Arrays.asList("inventory", "armor", "offhand"));
    private static SuggestionProvider<CommandSource> invtype;

    public static ArgumentBuilder<CommandSource, ?> register() {
        if (CrashUtils.curiosLoaded && CuriosApi.getSlotHelper() != null) {
            invTypes.addAll(CuriosApi.getSlotHelper().getSlotTypeIds());
        }
        invtype = (ctx, builder) -> ISuggestionProvider.func_197013_a(invTypes.stream(), (SuggestionsBuilder)builder);
        return Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).then(Commands.func_197056_a((String)"slotType", (ArgumentType)StringArgumentType.string()).suggests(invtype).then(Commands.func_197056_a((String)"slot", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RemoveFromInventorySlotCommand.removeFromSlot((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"slotType"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot")))))).then(Commands.func_197056_a((String)"slot", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RemoveFromInventorySlotCommand.removeFromSlot((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), "inventory", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot")))));
    }

    private static int removeFromSlot(CommandContext<CommandSource> context, String name, String inventoryType, int slot) {
        AtomicReference<StringTextComponent> text = new AtomicReference<StringTextComponent>(new StringTextComponent(""));
        AtomicBoolean success = new AtomicBoolean(false);
        WorldUtils.applyToPlayer(name, ((CommandSource)context.getSource()).func_197028_i(), player -> {
            switch (inventoryType) {
                case "inventory": {
                    if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b()) {
                        success.set(false);
                        return;
                    }
                    text.set((StringTextComponent)((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_151000_E().func_230532_e_());
                    player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
                    break;
                }
                case "armor": {
                    if (((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_190926_b()) {
                        success.set(false);
                        return;
                    }
                    text.set((StringTextComponent)((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_151000_E().func_230532_e_());
                    player.field_71071_by.field_70460_b.set(slot, (Object)ItemStack.field_190927_a);
                    break;
                }
                case "offhand": {
                    if (((ItemStack)player.field_71071_by.field_184439_c.get(slot)).func_190926_b()) {
                        success.set(false);
                        return;
                    }
                    text.set((StringTextComponent)((ItemStack)player.field_71071_by.field_184439_c.get(slot)).func_151000_E().func_230532_e_());
                    player.field_71071_by.field_184439_c.set(slot, (Object)ItemStack.field_190927_a);
                    break;
                }
                default: {
                    if (!CrashUtils.curiosLoaded || !CuriosApi.getSlotHelper().getSlotTypeIds().contains(inventoryType)) break;
                    ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null);
                    if (((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().getStackInSlot(slot).func_190926_b()) {
                        success.set(false);
                        return;
                    }
                    text.set((StringTextComponent)((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().getStackInSlot(slot).func_151000_E().func_230532_e_());
                    ((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().setStackInSlot(slot, ItemStack.field_190927_a);
                }
            }
            success.set(true);
        });
        if (success.get()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)((IFormattableTextComponent)text.get()).func_230529_a_((ITextComponent)new StringTextComponent(" has been deleted from " + name + "'s InventorySlot")), true);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Failed to delete item from slot" + slot + ", slot is empty?"), true);
        }
        return 1;
    }
}

