/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class InventoryCommands {
    private InventoryCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("inventory", class_2561.method_43471((String)"crafttweaker.command.description.inventory"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IInventoryWrapper inventory = Services.PLATFORM.getPlayerInventory((class_1657)player);
            String inventoryContents = IntStream.range(0, inventory.getContainerSize()).mapToObj(inventory::getItem).filter(it -> !it.method_7960()).map(ItemStackUtil::getCommandString).collect(Collectors.joining("\n", "Inventory items\n", ""));
            CommandUtilities.COMMAND_LOGGER.info(inventoryContents);
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.inventory.list")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerSubCommand("inventory", "tags", class_2561.method_43471((String)"crafttweaker.command.description.inventory.tags"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IInventoryWrapper inventory = Services.PLATFORM.getPlayerInventory((class_1657)player);
            String inventoryContents = IntStream.range(0, inventory.getContainerSize()).mapToObj(inventory::getItem).filter(it -> !it.method_7960()).map(it -> Pair.of((Object)ItemStackUtil.getCommandString(it), CraftTweakerTagRegistry.INSTANCE.knownTagManager(class_7924.field_41197).getTagsFor(it.method_7909()))).map(it -> (String)it.getFirst() + "\n" + InventoryCommands.stringify((Collection)it.getSecond())).collect(Collectors.joining("\n", "Inventory item tags\n", ""));
            CommandUtilities.COMMAND_LOGGER.info(inventoryContents);
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.inventory.list.tag")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerSubCommand("inventory", "registryNames", class_2561.method_43471((String)"crafttweaker.command.description.inventory.registryNames"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IInventoryWrapper inventory = Services.PLATFORM.getPlayerInventory((class_1657)player);
            String inventoryContents = IntStream.range(0, inventory.getContainerSize()).mapToObj(inventory::getItem).filter(it -> !it.method_7960()).map(class_1799::method_7909).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).map(class_2960::toString).collect(Collectors.joining("\n", "Inventory items\n", ""));
            CommandUtilities.COMMAND_LOGGER.info(inventoryContents);
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.inventory.list")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
    }

    private static String stringify(Collection<KnownTag<class_1792>> tags) {
        if (tags.isEmpty()) {
            return "- No tags";
        }
        return tags.stream().map(MCTag::getCommandString).map(it -> String.format("- %s", it)).collect(Collectors.joining("\n"));
    }
}

