/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.impl.command.CommandImpl;
import com.blamejared.crafttweaker.impl.command.CtCommands;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public final class HelpCommand {
    private static final int COMMANDS_PER_PAGE = 4;

    private HelpCommand() {
    }

    public static void registerCommandIfRequired(CtCommands instance) {
        Map<String, CommandImpl> commands = instance.commands();
        if (commands.containsKey("help")) {
            return;
        }
        instance.registerCommand("help", class_2561.method_43471((String)"crafttweaker.command.description.help"), builder -> {
            builder.executes(context -> HelpCommand.executeHelp(commands, (CommandContext<class_2168>)context, 1));
            builder.then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> HelpCommand.executeHelp(commands, (CommandContext<class_2168>)context, (Integer)context.getArgument("page", Integer.TYPE))));
        });
    }

    private static int executeHelp(Map<String, CommandImpl> commands, CommandContext<class_2168> context, int currentPage) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        List<String> allowedToUseCommands = commands.keySet().stream().filter(s -> ((CommandImpl)commands.get(s)).requirement().test(source)).toList();
        int maxPages = (int)Math.ceil((double)allowedToUseCommands.size() / 4.0);
        int clampedPage = class_3532.method_15340((int)currentPage, (int)1, (int)maxPages);
        int minIndex = (clampedPage - 1) * 4;
        int maxIndex = Math.min(commands.size(), minIndex + 4);
        for (int i = minIndex; i < maxIndex; ++i) {
            CommandImpl command = commands.get(allowedToUseCommands.get(i));
            String commandStr = "/ct " + command.name();
            source.method_9226(() -> CommandUtilities.run(class_2561.method_43470((String)commandStr), commandStr), true);
            source.method_9226(() -> class_2561.method_43470((String)"- ").method_10852((class_2561)command.description().method_27692(class_124.field_1062)), true);
        }
        source.method_9226(() -> class_2561.method_43469((String)"crafttweaker.command.help.page.info", (Object[])new Object[]{clampedPage, maxPages}), true);
        return 1;
    }
}

