/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;

public final class IngredientUtil {
    public static boolean canConflict(class_1856 a, class_1856 b) {
        return IngredientUtil.canConflict(a, b, class_1856::method_8103, class_1856::method_8105, ItemStackUtil::areStacksTheSame);
    }

    public static <T extends Predicate<U>, U> boolean canConflict(T a, T b, Predicate<T> isEmpty, Function<T, U[]> elements, BiPredicate<U, U> compare) {
        return a == b || elements.apply(a).length == 0 && elements.apply(b).length == 0 || !IngredientUtil.findIntersection(a, b, isEmpty, elements, compare).isEmpty();
    }

    public static List<class_1799> findIntersection(class_1856 a, class_1856 b) {
        return IngredientUtil.findIntersection(a, b, class_1856::method_8103, class_1856::method_8105, ItemStackUtil::areStacksTheSame);
    }

    public static boolean doIngredientsConflict(List<class_1856> first, List<class_1856> second) {
        return IngredientUtil.doIngredientsConflict(first, second, class_1856::method_8103, class_1856::method_8105, ItemStackUtil::areStacksTheSame);
    }

    public static <T extends Predicate<U>, U> boolean doIngredientsConflict(List<T> first, List<T> second, Predicate<T> isEmpty, Function<T, U[]> elements, BiPredicate<U, U> compare) {
        BitSet visitData = new BitSet(second.size());
        block0: for (Predicate target : first) {
            for (int j = 0; j < second.size(); ++j) {
                Predicate attempt;
                if (visitData.get(j) || !IngredientUtil.canConflict(target, attempt = (Predicate)second.get(j), isEmpty, elements, compare)) continue;
                visitData.set(j);
                continue block0;
            }
        }
        return visitData.nextClearBit(0) == second.size();
    }

    public static <T extends Predicate<U>, U> List<U> findIntersection(T a, T b, Predicate<T> isEmpty, Function<T, U[]> elements, BiPredicate<U, U> compare) {
        if (isEmpty.test(a) || isEmpty.test(b)) {
            return List.of();
        }
        U[] aElements = elements.apply(a);
        U[] bElements = elements.apply(b);
        if (a == b) {
            return List.of(aElements);
        }
        ArrayList<U> intersection = null;
        for (U aElement : aElements) {
            for (U bElement : bElements) {
                if (!compare.test(aElement, bElement)) continue;
                if (intersection == null) {
                    intersection = new ArrayList<U>();
                }
                intersection.add(aElement);
            }
        }
        return intersection == null ? List.of() : intersection;
    }
}

