/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister(loaders={"crafttweaker", "tags"})
@Document(value="vanilla/api/tag/manager/ITagManager")
@ZenCodeType.Name(value="crafttweaker.api.tag.manager.ITagManager")
public interface ITagManager<T extends MCTag>
extends CommandStringDisplayable,
Iterable<T>,
Comparable<ITagManager<?>> {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagFolder")
    default public String tagFolder() {
        return CraftTweakerTagRegistry.INSTANCE.makeTagFolder(this.resourceKey());
    }

    @ZenCodeType.Method
    public T tag(String var1);

    @ZenCodeType.Method
    public T tag(class_2960 var1);

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagMap")
    public Map<class_2960, T> tagMap();

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean exists(String id) {
        return this.exists(new class_2960(id));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean exists(class_2960 id) {
        return this.tagKeys().contains(id);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean exists(T tag) {
        return this.exists(tag.id());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagKeys")
    public List<class_2960> tagKeys();

    @Override
    default public String getCommandString() {
        return "<tagmanager:" + this.tagFolder() + ">";
    }

    public <U> void addTag(class_2960 var1, Collection<class_6880<U>> var2);

    public Map<class_2960, Collection<class_6880<?>>> internalTags();

    public void bind(class_3505.class_6863<?> var1);

    default public Optional<Class<?>> elementClass() {
        return Optional.empty();
    }

    @ZenCodeType.Method
    public void addId(T var1, class_2960 ... var2);

    @ZenCodeType.Method
    public void removeId(T var1, class_2960 ... var2);

    @ZenCodeType.Method
    public void clear(T var1);

    @ZenCodeType.Method
    default public List<class_2960> idElements(T of) {
        if (!this.exists(of)) {
            return List.of();
        }
        return this.getInternalRaw(of).stream().map(class_6880::method_40230).filter(Optional::isPresent).map(Optional::get).map(class_5321::method_29177).collect(Collectors.toList());
    }

    @Nullable
    public Collection<class_6880<?>> getInternalRaw(T var1);

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tags")
    default public List<T> tags() {
        return new ArrayList<T>(this.tagMap().values());
    }

    @ZenCodeType.Method
    default public List<T> getTagsFor(class_2960 element) {
        return this.tags().stream().filter(tag -> tag.contains(element)).toList();
    }

    public class_5321<? extends class_2378<?>> resourceKey();

    public void recalculate();

    default public T tag(class_6862<?> key) {
        return this.tag(key.comp_327());
    }

    @Override
    @Nonnull
    default public Iterator<T> iterator() {
        return this.tags().iterator();
    }

    @Override
    default public int compareTo(@Nonnull ITagManager<?> o) {
        return this.tagFolder().compareTo(o.tagFolder());
    }
}

