/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.serializer;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction1D;
import com.blamejared.crafttweaker.api.recipe.type.CTShapelessRecipe;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class CTShapelessRecipeSerializer
implements class_1865<CTShapelessRecipe> {
    public static final CTShapelessRecipeSerializer INSTANCE = new CTShapelessRecipeSerializer();

    private CTShapelessRecipeSerializer() {
    }

    private static class_2371<class_1856> readIngredients(JsonArray p_199568_0_) {
        class_2371 nonnulllist = class_2371.method_10211();
        for (int i = 0; i < p_199568_0_.size(); ++i) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)p_199568_0_.get(i));
            if (ingredient.method_8103()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public CTShapelessRecipe fromJson(class_2960 recipeId, JsonObject jsonObject) {
        class_2371<class_1856> nonnulllist = CTShapelessRecipeSerializer.readIngredients(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients"));
        IIngredient[] ingredients = new IIngredient[nonnulllist.size()];
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ingredients[i] = IIngredient.fromIngredient((class_1856)nonnulllist.get(i));
        }
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        class_1799 itemstack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        return this.makeRecipe(recipeId, IItemStack.of(itemstack), ingredients, null);
    }

    public CTShapelessRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
        int i = buffer.method_10816();
        IIngredient[] ingredients = new IIngredient[i];
        for (int j = 0; j < ingredients.length; ++j) {
            ingredients[j] = IIngredient.fromIngredient(class_1856.method_8086((class_2540)buffer));
        }
        class_1799 output = buffer.method_10819();
        return this.makeRecipe(recipeId, IItemStack.of(output), ingredients, null);
    }

    public void toNetwork(class_2540 buffer, CTShapelessRecipe recipe) {
        buffer.method_10804(recipe.method_8117().size());
        for (class_1856 ingredient : recipe.method_8117()) {
            ingredient.method_8088(buffer);
        }
        buffer.method_10793(AccessibleElementsProvider.get().registryAccess(recipe::method_8110));
    }

    public CTShapelessRecipe makeRecipe(class_2960 recipeId, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunction1D function) {
        return new CTShapelessRecipe(recipeId.method_12832(), output, ingredients, function);
    }
}

