/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe.generic;

import com.blamejared.crafttweaker.api.action.recipe.generic.ActionWholeRegistryBase;
import com.blamejared.crafttweaker.api.recipe.RecipeList;
import com.blamejared.crafttweaker.api.recipe.manager.RecipeManagerWrapper;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1860;
import net.minecraft.class_3956;

public class ActionRemoveAllGenericRecipes
extends ActionWholeRegistryBase {
    @Override
    public void apply() {
        Map<class_3956<class_1860<?>>, RecipeList<?>> recipeLists = this.getRecipeLists();
        TreeMap<String, Integer> numberOfRemovedRecipesByType = new TreeMap<String, Integer>();
        int totalRemoved = 0;
        for (class_3956<class_1860<?>> recipeType : recipeLists.keySet()) {
            int removedRecipes = this.remove(recipeLists.get(recipeType));
            if (removedRecipes <= 0) continue;
            totalRemoved += removedRecipes;
            String commandString = new RecipeManagerWrapper(recipeType).getCommandString();
            numberOfRemovedRecipesByType.put(commandString, removedRecipes);
        }
        int managerCount = numberOfRemovedRecipesByType.size();
        String recipeTypeList = this.makeRecipeList(numberOfRemovedRecipesByType);
        this.logger().info("Removed {} recipes across these {} managers: {}", (Object)totalRemoved, (Object)managerCount, (Object)recipeTypeList);
    }

    private int remove(RecipeList<?> list) {
        int size = list.getSize();
        list.removeAll();
        return size;
    }

    @Override
    public String describe() {
        return "Removing all recipes";
    }
}

